---
layout: outline
title: GitHub Foundations Course Outline
description: A student and teacher outline to the GitHub Foundations class.
---

This outline will be your companion for the cheat sheet and slides of the GitHub Foundations class taught by the [GitHub Training Team](http://training.github.com/) and other educational groups.


## Introduction
###  Git
###  GitHub
###  A Brief Tour of Git

## Setup
###  GitHub Account
###  GitHub Installers
###  Git version

## Config
### User information
### Scopes
### Viewing all
### Useful settings
### Settings video

## Init
### Repository from scratch
### Repository from existing dir

## Commit
### Three stage thinking
### Shopping cart
### Your first commit
### What is a commit
### Versions and files
### Current branch tip
### Parent reference
### Ancestor reference

## Diff
### Comparing changes
### Comparing to staged
### Comparing to repo
### Useful options

## Log
### Show all history
### Show history patches
### History formatting
### Limiting output
### Additional options
### Searching commits

## Remove & Move
### Tracking states map
### Tracking states in motion
### Deleting files
### Stop tracking
### Move and stage
### Similarity index

## Ignore
### Ignoring files
### Ignore patterns
### Controlling ignores
### Excludes file

## Checkout
### Purpose of checkout
### Discarding changes
### Switching branches
### Exploring history

## Branch
### Flexibility
### Listing
### Creating
### Deleting
### Renaming

## Merge
### Basics
### Recursive
### Fast forward
### Conflicting merges
### Resolution selection

## Rebase
### Reasons
### Fast forward
### Against a branch
### Interactive
### Interactive command

## Network
### Remotes
### Adding a remote
### Remotes are immutable
### Listing remote branches
### Sharing with a push
### Pull vs fetch

## GitHub
### GitHub hosted repo
### Cloning from GitHub

## Forking
### Purpose of forking

## Pull Requests
### Promoting collaboration
### Forks and pull requests

## Reset
### Losing data is difficult
### Recover from history
### Hard reset warning

## GUIs
### Native tools
### Other tools
### Diff tool
### Merge tool

## Reflog
### Restoring by action
### Reflog video
