---
layout: simple-class
header:
  overlay_image: cover.jpeg
  overlay_filter: rgba(46, 129, 200, 0.6)
help: https://github.com/githubtraining/on-demand-merge-conflict/issues/new?title=I%20need%20help&body=Describe%20what%20you%20need%20help%20with%20here.&labels=Help%20Wanted
title: Momtocat and Poptocat Lend a Hand
permalink: /merge-conflicts/example-03/
next-page: /merge-conflicts/what-next/
sidebar:
  nav: "merge-conflicts"
main-content: |
  So, our resume is slowly taking shape, after modifying the contact information in the `_config.yml` file, we turned our attention to the `experience.yml` file. To wrap up, we need to finish adding our education and interests to the resume.

  [![instructions for this activity](../../images/gifs/merge-conflict/username-education.gif)](../../images/gifs/merge-conflict/username-education.gif)

  1. In your imported version of the repository, checkout to the branch named: `username-education`.
  1. While on that branch, open the `_data/education.yml` file.
  1. Modify the content in the `degree`, `uni`, `year`, and `summary` lines.

      > The `education.yml` file supports displaying awards you may have received, you can add that on a new line between `year:` and `summary:`.

  1. Save your changes to the `education.yml` file and create a new commit.
  1. While on the `username-education` branch, open the `_data/interests.yml` file.
  1. Replace the existing interests with your interests. For example `description: Learning about Git and GitHub` could be one of your interests.
  1. Save your changes to the `interests.yml` file and create a new commit.

        > If you made the changes on your local machine, push your changes back to repository on GitHub.

  1. Create a new pull request. Use the **base:** of `master` and the **compare:** of `username-education`.
  1. Click **Create pull request**.
  1. In the **This branch has conflicts that must be resolved** section of the pull request, you can click the **Resolve conflicts** button to resolve the merge conflict.
  1. It would appear that Momtocat and Poptocat recently made changes to the `master` branch and modified the same files you did, this is what is causing the merge conflicts. Similar to when we had to resolve a merge conflict with Skatetocat's changes, remove Momtocat's contributions from the `education.yml` and Poptocat's contributions from the `interests.yml` files.

        ![momtocat](https://octodex.github.com/images/momtocat.png)

  1. With the merge conflict markers removed, click **Mark as resolved**
  1. Click **Commit merge**.
  1. With the merge conflicts resolved, click **Merge pull request**.

        ![poptocat](https://octodex.github.com/images/poptocat.png)

---
