---
layout: simple-class
header:
  overlay_image: cover.jpeg
  overlay_filter: rgba(46, 129, 200, 0.6)
help: https://github.com/githubtraining/on-demand-merge-conflict/issues/new?title=I%20need%20help&body=Describe%20what%20you%20need%20help%20with%20here.&labels=Help%20Wanted
title: Shoptocat and Supportcat Help
permalink: /merge-conflicts/example-02/
next-page: /merge-conflicts/example-03/
sidebar:
  nav: "merge-conflicts"
main-content: |

  Since we customized the resume to include our information, we should include our current professional experience. To include our experience we need to modify the `experience.yml` file.

  [![instructions for this activity](../../images/gifs/merge-conflict/username-experience.gif)](../../images/gifs/merge-conflict/username-experience.gif)

  1. In your imported version of the repository, checkout to the branch named: `username-experience`.
  1. While on that branch, open the `_data/experience.yml` file.
  1. Modify the content on lines 2 through 6 and 15 through 19 making sure to provide information in the `company`, `position`, `duration`, and `summary` lines.
   
        > Later you can go back and modify the `experience.yml` to be consistent with your experience. 

  1. After making the changes, create a commit, an example commit message might be: `Add my experience`.

        > If you made the changes on your local machine, push your changes back to repository on GitHub.

  1. Create a new pull request. Use the **base:** of `master` and the **compare:** of `username-experience`.
  1. Click **Create pull request**.
  1. In the **This branch has conflicts that must be resolved** section of the pull request, click the **Resolve conflicts** button to resolve the merge conflict.
  1. It would appear that Shoptocat and Supportcat recently made changes to the `master` branch and modified the same file you did, this is what is causing the merge conflicts. Similar to when we had to resolve a merge conflict with Mummytocat's changes, remove Shoptocat and Supportcat's contributions from the `experience.yml` file. If you need a refresher on how to resolve a merge conflict, check the **I need a refresher** section below.

       > In the video instructions above, you might notice that @beardofedu ran into 2 conflicts in the same file. That is because they edited lines 2 - 6 and 15 - 19, so Git identified the two changes within the file as two separate conflicts. Had they edited lines 2 - 19, it would have been one merge conflict.

       ![shoptocat](https://octodex.github.com/images/shoptocat.png)

  1. With the merge conflict markers removed, click **Mark as resolved** 
  1. Click **Commit merge**.
  1. With the merge conflicts resolved, click **Merge pull request**. 

        ![supportcat](https://octodex.github.com/images/supportcat.png)

refresh: |

  To remove the merge conflict, we should identify the content we want to keep and the content we want to remove. Then, remove the unnecessary content, and remove all conflict markers.
---
