---
layout: simple-class
header:
  overlay_image: cover.jpeg
  overlay_filter: rgba(46, 129, 200, 0.6)
help: https://github.com/githubtraining/on-demand-merge-conflict/issues/new?title=I%20need%20help&body=Describe%20what%20you%20need%20help%20with%20here.&labels=Help%20Wanted
title: Skatetocat's Simple Conflict
permalink: /merge-conflicts/example-01/
next-page: /merge-conflicts/example-02/
sidebar:
  nav: "merge-conflicts"
main-content: |
  We need to modify the resume template so it contains our information. Using the [GitHub Flow](https://guides.github.com/introduction/flow/), we can make those changes by:

  [![instructions for this activity](../../images/gifs/merge-conflict/username-config.gif)](../../images/gifs/merge-conflict/username-config.gif)

  1. In your imported version of the repository, checkout to the branch named: `username-config`.
  1. While on that branch, open the `_config.yml` file.
  1. Modify lines 12-19 with your information. If you would prefer to create a fictional resume, your favorite fictional character's information.
  1. After making the changes, create a commit, an example commit message might be: `Add my information`.

      > If you made the changes on your local machine, push your changes back to repository on GitHub.

  1. Create a new pull request. Use the **base:** of `master` and the **compare:** of `username-config`.
  1. Although GitHub reports that you can't automatically merge these changes, you can still start the pull request. Click **Create pull request**.
  1. In the **This branch has conflicts that must be resolved** section of the pull request, click the **Resolve conflicts** button to resolve the merge conflict.
  1. It would appear that Skatetocat recently made changes to the `master` branch and modified the exact same line you did, this is what caused the merge conflict to occur. Click "Resolve conflicts", and remove Skatetocat's contributions to the `master` branch by deleting all of the content below the `=======` and above the `>>>>>>> master` content.

      ![Skatetocat](https://octodex.github.com/images/skatetocat.png)

  1. We still can't mark as resolved because we need to remove the merge conflict markers. Delete the following lines: `<<<<<<< username-config`, `=======`, and `>>>>>>> master`.
  1. With the merge conflict markers removed, click **Mark as resolved**. 
  1. Click **Commit merge**.
  1. Congratulations, you successfully resolved a merge conflict! Go ahead and merge the pull request.

---
