---
lang: en
ref: intro-to-github-07
layout: simple-class
help: https://github.com/githubschool/open-enrollment-classes-introduction-to-github/issues/new?title=I%20need%20help&body=Describe%20what%20you%20need%20help%20with%20here.&labels=Help%20Wanted
header:
  overlay_image: cover.jpeg
  overlay_filter: rgba(46, 129, 200, 0.6)
title: Work on GitHub
permalink: /intro-to-github/work-on-github
next-page: /intro-to-github/create-pull-request
sidebar:
  nav: "intro-nav"
main-content:
  includes:
  - activity/intro-to-github/04-create-a-file-on-github.md
show-me-how:
tell-me-why: |

  ## Add a New File

  To add your pin, add a new file to the class repository. We gave you specific instructions above, but first consider some of the helpful ways GitHub allows you to add files to your projects.

  - **File Uploader:** if you already have a file on your computer that you would like to add to your repository, simply drag and drop it in to the repository window on GitHub.
  - **Create New File:** you can also choose to create a new file in your repository by clicking the **Create new file** button. This opens a simple, web-based file editor. First, provide a file name with the appropriate file extension. The file extension will tell GitHub how to render your content.
  - **Modifying an Existing File:** Sometimes you simply need to make a change to an existing file. If this is the case, navigate to the file using the file directory in the Code tab. Once you have opened the file, click the pencil icon in the top right to open the file in edit mode.

  ## Commit Your Changes

  When you are finished creating or making changes to a file on GitHub, scroll to the bottom of the page. There, find a **Commit new file** section.

  In the first field, type a commit message. The commit message should briefly tell others about the changes you are introducing to the file.

  #### Rules to Live By For Commits:

  - Don't end your commit with a period.
  - Keep your commits to 50 characters or less. Add extra detail in the extended description window, if necessary. This is located just below the subject line.
  - Commits use the imperative mood. _Add_ instead of _Added_. _Merge_ instead of _Merged_.
  - Think of your commit as expressing intent to introduce a change.

  ## Choose Your Branch

  Next, designate where you want your changes to be committed. If you were on your branch when you clicked the **Create new file** button, GitHub will prompt you to commit directly to that branch. But, if you forgot to create a new branch, you can do it now.

---
