---
lang: en
ref: intro-to-github-05
layout: simple-class
help: https://github.com/githubschool/open-enrollment-classes-introduction-to-github/issues/new?title=I%20need%20help&body=Describe%20what%20you%20need%20help%20with%20here.&labels=Help%20Wanted
header:
  overlay_image: cover.jpeg
  overlay_filter: rgba(46, 129, 200, 0.6)
title: Create a Branch
permalink: /intro-to-github/create-a-branch
next-page: /intro-to-github/find-your-coordinates
sidebar:
  nav: "intro-nav"
main-content:
  includes:
  - activity/intro-to-github/03-create-branch.md
show-me-how:
tell-me-why: |
  ## Creating A Branch

  You just learned that the first step in the GitHub Workflow is to create a branch.

  Branches are an important part of the GitHub workflow because they allow us to separate our work from the `master` branch. In other words, everyone's pins that are already shown on the map will be safe while you learn how to add yours.

  Since branches are so important, we recommend you take a look at this video to learn more:

  <iframe width="560" height="315" src="https://www.youtube.com/embed/xgQmu81G1yY" frameborder="0" allowfullscreen></iframe>

  ## Tips for Using Branches

  A single project like ours can have hundreds of branches - all trying out new features or alternate approaches to the same feature.

  The trick in managing branches with a team is to keep them concise and short lived. In other words, a single branch should represent a single new feature or bug fix. And, while GitHub doesn't limit the number of branches you can have, it makes things a lot less confusing when you only keep them active for a few days and delete them after they have been merged (we will discuss merging a little later).

---
