---
lang: en
ref: intro-to-github-03
layout: simple-class
help: https://github.com/githubschool/open-enrollment-classes-introduction-to-github/issues/new?title=I%20need%20help&body=Describe%20what%20you%20need%20help%20with%20here.&labels=Help%20Wanted
header:
  overlay_image: cover.jpeg
  overlay_filter: rgba(46, 129, 200, 0.6)
title: Explore the GitHub Repository
permalink: /intro-to-github/explore-github-repository
next-page: /intro-to-github/use-github-flow
sidebar:
  nav: "intro-nav"
main-content: |
  Take a few minutes to familiarize yourself with the layout of a GitHub repository:

  ![gif of directions](../images/gifs/intro/explore-repo.gif)

  1. Watch the video in the **Tell me why** section for a guided tour.
  2. Navigate to the **Code** tab to find the repository README.
  3. Click on an **Issue** and a **Pull Request** to see the difference (HINT: one contains changes to code, the other does not).
  4. Click **Insights** and select the **Pulse** or **Graphs** sub-options to view some of our repository stats.
show-me-how:
tell-me-why: |

  ## Exploring A GitHub Repository

  Now that you have a repository, check out this short video to learn about the key features it contains:

  <iframe width="560" height="315" src="https://www.youtube.com/embed/R8OAwrcMlRw" frameborder="0" allowfullscreen></iframe>

  ### More Great Features

  The video covered some of the most commonly used features. Here are a few other items of interest you can find in GitHub repositories:

  - **Projects:** You can create Kanban style project tracking boards within GitHub.
  - **Wiki**: GitHub also has a place to create and store your relevant project documentation.
  - **Insights**: A drop-down menu option that contains links to different analytic tools for your repository. It contains the following items:
     - **Pulse**: Pulse is our project's dashboard. It contains information on the work that has been completed and the work in progress.
     - **Graphs**: Graphs provide a more granular view of the repository activity, including who has contributed, when the work has been done, and who has forked the repository.

  ### Special Files

  In the video you learned about a special file called the README.md. Here are a few other special files you can add to your repositories:

  - **CONTRIBUTING.md**: The `CONTRIBUTING.md` is used to describe the process for collaborating on the repository. The link to the `CONTRIBUTING.md` file is shown anytime someone begins to create a new issue or pull request.
  - **ISSUE_TEMPLATE.md**: The `ISSUE_TEMPLATE.md` is yet another special file you can use to pre-populate the body of an issue. For example, if you always want to gather certain types of information for bug reports, you can include it in the issue template and every new issue will be opened with your recommended starter text.

---
