---
lang: es
ref: intro-to-github-03
layout: simple-class
help: https://github.com/githubschool/open-enrollment-classes-introduction-to-github/issues/new?title=I%20need%20help&body=Describe%20what%20you%20need%20help%20with%20here.&labels=Help%20Wanted
header:
  overlay_image: cover.jpeg
  overlay_filter: rgba(46, 129, 200, 0.6)
title: Explora el repositorio de GitHub
permalink: /intro-to-github/es/explora-repositorio
next-page: /intro-to-github/es/flujo-github
sidebar:
  nav: "intro-nav-es"
main-content: |
  Tómate unos minutos para familiarizarte con la estructura de un repositorio GitHub:

  ![gif of directions](../../images/gifs/intro/explore-repo.gif)

  1. Mira el video en la sección **Dime por qué** para un tour guiado.
  2. Navega a la pestaña **Code** (código) para encontrar el README del repositorio.
  3. Haz clic en un **Issue** y en un **Pull Request** para ver la diferencia (PISTA: uno contiene cambios en el código, el otro no).
  4. Haz clic en **Insights** y selecciona las opciones **Pulse** o **Graphs** para ver algunas estadísticas del repositorio.
show-me-how:
tell-me-why: |

  ## Explorando un repositorio GitHub

  Ahora que ya tienes un repositorio, mira este breve video para conocer las características clave de que dispone:

  <iframe width="560" height="315" src="https://www.youtube.com/embed/R8OAwrcMlRw" frameborder="0" allowfullscreen></iframe>

  ### Más características geniales

  El video cubre algunas de las características más utilizadas. Aquí tienes algunas otras cosas interesantes que puedes encontrar en los repositorios GitHub:

  - **Projects:** Aquí puedes crear paneles de seguimiento de proyectos tipo Kanban dentro de GitHub.
  - **Wiki**: GitHub también tiene un espacio donde crear y alojar la documentación relevante para tu proyecto.
  - **Insights**: Una opción de menú desplegable que contiene enlaces a diferentes herramientas analíticas para tu repositorio. Dispone de las siguientes opciones:
     - **Pulse**: Pulse es el dashboard o panel de nuestro proyecto. Contiene información sobre el trabajo que se ha completado y el trabajo en curso.
     - **Graphs**: Graphs ofrece una visión más detallada y granular de la actividad del repositorio, incluyendo quién ha contribuido, cuándo se ha realizado el trabajo, y quién ha hecho un fork del repositorio.

  ### Archivos especiales

  En el video has aprendido que existe un archivo especial llamado README.md. Aquí tienes algunos otros archivos especiales que puedes añadir a tus repositorios:

  - **CONTRIBUTING.md**: El archivo `CONTRIBUTING.md` se utiliza para describir el proceso para colaborar con el repositorio. El enlace al archivo `CONTRIBUTING.md` se muestra cada vez que alguien empieza a crear un nuevo issue o pull request.
  - **ISSUE_TEMPLATE.md**: El archivo `ISSUE_TEMPLATE.md` es otro archivo especial más que puedes utilizar como plantilla del cuerpo de un issue. Por ejemplo, si siempre quieres recoger cierto tipo de información para los informes de error, puedes incluirlos en este documento y todos los nuevos issues se abrirán conteniendo este texto.

---
