---
layout: simple-class
header:
  overlay_image: cover.jpeg
  overlay_filter: rgba(46, 129, 200, 0.6)
title: Git Trouble Scenarios
permalink: /git-trouble/git-scenarios
facilitator: false
sidebar:
  nav: "advanced"
main-content: |  

  Unlike our other [courses](../), this course doesn't follow a linear path and you can jump into any of the different scenarios provided. So `git` ready to learn about how to get out of trouble with a healthy dose of terrible `git` puns.

  ## [Too Many (small) Git Commits!](../git-trouble/too-many-commits)

  While you were making changes, you might have created a bunch of tiny commits, but when it is time to push your changes back to your `remote`, you want to prevent your commit history from being inundated with the 30 commits you just made. This scenario guides you through creating a more concise history.

  ## [Git Commit Message Sucks](../git-trouble/git-commit-message)

  'Edited stuff' might have seemed like a decent commit message at 3am, but in hindsight, you might want to provide a _little_ more context. Covering the different commands you can use to `revert` the error of your commit message-ways, this scenario identifies how to get more descriptive.

  ## [Git Committed to Wrong Branch](../git-trouble/git-commit-wrong-branch)

  So you got excited about making some changes and accidentally committed your changes to the wrong branch? Happens **all** the time. This scenario walks you through the steps required to successfully remove those commits and commit them to the right branch, even if you already pushed them up!

  ## [Accidental Git Commit](../git-trouble/accidental-git-commit)

  Did you make a commit before you had actually finished all of the related changes? Maybe you left one lonely little change in the working directory? Perhaps your commit included changes that were unrelated. In either case, we can fix that, just follow along and `git` out of trouble.

  ## [Just Make it Go Away! - Breaking Things With Git](../git-trouble/breaking-things-with-git)

  That innovative fix was **supposed** to fix everything! Instead, your project is a garbage fire, and you just want everything to go back to how it was. Have no fear; we can make that happen and `git` you back on track.

  ## We Love Feedback :heart:

  Did you find this course helpful? [Let us know](https://www.surveygizmo.com/s3/3288550/git-reset)! Did it lose you somewhere? [Tell us about it](http://www.surveygizmo.com/s3/3288550/git-reset)! You may also like to opt-in for updates on future classes.

show-me-how:
tell-me-why:
---
