### Creating a Pull Request

Pull Requests are used to propose changes to the project files. A pull request introduces an action that addresses an Issue. A Pull Request is considered a "work in progress" until it is merged into the project. Now that you have created a file, you will open a pull request to discuss the file with your team mates:

- GitHub knows that you have added changes to your branch and helpfully recommends that you start a pull request.
- Go ahead and click the big green button to start your pull request.
- Notice that we can use the drop down here to compare any two branches. We will leave the defaults selected.
- GitHub pre-populates the commit message as the pull request title. You can change this to help your collaborators better understand the intent of the change.
- Here you can leave a comment to describe the changes you made and why. As a best practice, you should reference the original issue or issues using the # notation.
- When you are finished, choose the option to create a pull request.

### Collaborating on Pull Requests

Similar to the discussion thread on an Issue, a Pull Request creates a discussion about the changes being made to the repository. This discussion is found in the Conversation tab.

The commits view contains information about who has made changes to the files. Each commit is an updated view of the repository, allowing us to see how changes have happened from commit to commit.

The Files changed view allows you to see the change that is being proposed. We call this the `diff`. Notice that some of the text is highlighted in red. This is what has been removed. The green text is what has been added.

If you notice something that needs to be changed, you can click on the line number in this view to create a line comment. Line level comments are a great way to give additional context on recommended changes.

Notice that the line comment was added to the main conversation.

If your comment is more general in nature, you can also add a comment to the Pull Request using the same method we learned for Issues.

Most project teams require someone to sign off on the change before it is merged. We like to use emoji to show our approval. In the previous lab you created a file, next you will create a pull request for your file.
