---
layout: course
leadingpath: ../
title: GitHub for Developers
description: A tour through Git and GitHub concepts for those who use the command line.

sections:
  -
    title: Getting Started with Collaboration
    description: This section introduces you to GitHub and the collaboration features we will use throughout the class.
    modules:
      - COLL-00_Introducing-github
      - COLL-01_Exploring-a-repository
      - COLL-02_Using-issues
  -
    title: Creating Your First Pull Request
    description: In this section you will learn about the GitHub flow and create your first pull request.
    modules:
      - CONT-01_Understanding-github-flow
      - CONT-02_Using-branches
      - CONT-030_Creating-files-platform
      - CONT-035_Creating-pull-requests
      - POLL-01_Pace-poll-01
      - CONT-04_Editing-pull-request-files
      - CONT-05_Merging-pull-requests
  -
    title: Using GitHub Locally
    description: In this section you will learn how to clone the repository to your desktop and work locally to make changes.
    modules:
      - CONT-CLI-01_Basic-Configuration
      - CONT-CLI-02_Cloning-repository
      - CONT-CLI-03_Editing-local-files
      - CONT-CLI-04_Two_Stage_Commit
      - CONT-CLI-05_Sync-changes
  -
    title: The Workflow End-to-End
    description: In this section you will review the workflow from start-to-finish and learn a few shortcuts along the way.
    modules:
      - CONT-CLI-06_Creating-repository-github
      - CONT-CLI-07_Creating-local-branches
      - CONT-CLI-08_Workflow-review
      - CONT-CLI-09_Pulling-changes
      - POLL-02_Pace-poll-02
  -
    title: Working with Local Files
    description: In this section you will learn how to perform common file operations with git.
    modules:
      - CONT-CLI-10_Modifying-local-files
      - CONT-CLI-11_Viewing-local-diffs
      - CONT-CLI-12_Merging-changes
      - CONT-CLI-13_Viewing-project-history
  -
    title: Fixing Common Issues with Git
    description: In this section you will learn how to manipulate your repository and its history to craft a better story for your project.
    modules:
      - CONT-CLI-14_Creating-repository-local
      - CONT-CLI-21_Handling-merge-conflicts
      - CONT-CLI-15_Renaming-moving-files
      - CONT-CLI-16_Reverting-commits
      - CONT-CLI-17_Fixing-bad-commits
      - POLL-03_Pace-poll-03
      - CONT-CLI-18_Unstaging-files
      - CONT-CLI-19_Resetting-history
      - CONT-CLI-20_Discarding-changes-modified-files
      - CONT-CLI-22_Removing-tracked-files
  -
    title: Creating Shortcuts
    description: In this section you will learn how to create custom shortcuts for git commands.
    modules:
      - CONT-CLI-23_Creating-aliases

---
