export function genData(rows:number = 10):Array<any> {
  let products:Array<any> = [
      {
        description: 'Big Mac',
        options: [
          {description: 'Big Mac'},
          {description: 'Big Mac & Co'},
          {description: 'McRoyal'},
          {description: 'Hamburger'},
          {description: 'Cheeseburger'},
          {description: 'Double Cheeseburger'}
        ]
      },
      {
        description: 'Fried Potatoes',
        options: [
          {description: 'Fried Potatoes'},
          {description: 'Fried Onions'}
        ]
      }
    ],
    firstNames = ['Ted', 'John', 'Macy', 'Rob', 'Gwen', 'Fiona', 'Mario',
      'Ben', 'Kate', 'Kevin', 'Thomas', 'Frank'],
    lastNames = ['Tired', 'Johnson', 'Moore', 'Rocket', 'Goodman', 'Farewell',
      'Manson', 'Bentley', 'Kowalski', 'Schmidt', 'Tucker', 'Fancy'],
    address = ['Turkey', 'Japan', 'Michigan', 'Russia', 'Greece', 'France', 'USA',
      'Germany', 'Sweden', 'Denmark', 'Poland', 'Belgium'];

  let items:Array<any> = [];
  let product:any;
  let newProduct;

  for (let i = 0; i < rows; i++) {
    // clone expected product
    product = products[Math.floor(Math.random() * products.length)];
    newProduct = {
      description: product.description,
      options: []
    };
    product.options.forEach(function (p) {
      newProduct.options.push({description: p.description});
    });
    /// clone expected product

    items.push({
      id: i + 1,
      name: {
        first: firstNames[Math.floor(Math.random() * firstNames.length)],
        last: lastNames[Math.floor(Math.random() * lastNames.length)]
      },
      date: `${Math.max(Math.round(Math.random() * 12), 1)} / ${Math.max(Math.round(Math.random() * 28), 1)} /
      ${(Math.round(Math.random() * 80) + 1940)}`,
      address: `${Math.floor(Math.random() * 100000)} ${address[Math.floor(Math.random() * address.length)]}`,
      price: Math.floor(Math.random() * 100000) / 100,
      isActive: Math.floor(Math.random() * products.length) / 2 === 0 ? 'Yes' : 'No',
      product: newProduct
    });
  }

  return items;
};

export function getAdvancedData():Array<any> {
  return [
    ['Afghanistan', '30.552', '1000s', '2013', '0.0244', '27.708', '24.019', '11.215'],
    ['Albania', '2.774', '1000s', '2013', '-0.0100', '2.884', '3.015', '3.228'],
    ['Algeria', '39.208', '1000s', '2013', '0.0189', '36.383', '33.461', '25.577'],
    ['Angola', '21.472', '1000s', '2013', '0.0313', '18.927', '15.977', '10.051'],
    ['Antigua and Barbuda', '90', '1000s', '2013', '0.0103', '86', '82', '62'],
    ['Argentina', '41.446', '1000s', '2013', '0.0087', '40.024', '38.309', '32.17'],
    ['Armenia', '2.977', '1000s', '2013', '0.025', '2.968', '3.026', '3.543'],
    ['Australia', '23.131', '1000s', '2013', '0.0179', '21.692', '20.127', '16.814'],
    ['Austria', '8.474', '1000s', '2013', '0.0052', '8.365', '8.172', '7.62'],
    ['Azerbaijan', '9.296', '1000s', '2012', '0.0134', '8.763', '8.234', '6.994'],
    ['Bahrain', '1.332', '1000s', '2013', '0.0109', '1.192', '821', '481'],
    ['Bangladesh', '156.595', '1000s', '2013', '0.0123', '149.503', '141.235', '104.779'],
    ['Barbados', '285', '1000s', '2013', '0.0050', '279', '272', '258'],
    ['Belarus', '9.464', '1000s', '2012', '-0.0010', '9.528', '9.797', '10.14'],
    ['Belgium', '11.195', '1000s', '2013', '0.0060', '10.796', '10.421', '9.938'],
    ['Belize', '324', '1000s', '2012', '0.0246', '294', '258', '179'],
    ['Benin', '10.323', '1000s', '2013', '0.0271', '9.241', '7.923', '4.836'],
    ['Bhutan', '754', '1000s', '2013', '0.0163', '705', '634', '530'],
    ['Bolivia', '10.671', '1000s', '2013', '0.0167', '9.993', '9.188', '6.636'],
    ['Bosnia and Herzegovina', '3.829', '1000s', '2013', '-0.0012', '3.853', '3.887', '4.585'],
    ['Botswana', '2.021', '1000s', '2013', '0.0086', '1.952', '1.855', '1.343'],
    ['Brazil', '200.362', '1000s', '2013', '0.0086', '193.491', '184.01', '147.079'],
    ['Brunei', '418', '1000s', '2013', '0.0135', '394', '361', '250'],
    ['Bulgaria', '7.265', '1000s', '2013', '-0.0056', '7.444', '7.781', '8.877'],
    ['Burkina Faso', '16.935', '1000s', '2013', '0.0288', '15.095', '13.034', '8.58'],
    ['Burundi', '10.163', '1000s', '2013', '0.0318', '8.927', '7.511', '5.449'],
    ['Cambodia', '15.135', '1000s', '2013', '0.0182', '14.144', '13.149', '8.769'],
    ['Cameroon', '22.254', '1000s', '2013', '0.0255', '20.104', '17.675', '11.717'],
    ['Canada', '35.158', '1000s', '2013', '0.0116', '33.629', '31.995', '27.379'],
    ['Cape Verde', '499', '1000s', '2013', '0.0091', '486', '474', '346'],
    ['Central African Republic', '4.616', '1000s', '2013', '0.0202', '4.266', '3.894', '2.852'],
    ['Chad', '12.825', '1000s', '2013', '0.0303', '11.371', '9.665', '5.765'],
    ['Chile', '17.62', '1000s', '2013', '0.0089', '16.992', '16.168', '12.981'],
    ['China', '1.357.380', '1000s', '2013', '0.0049', '1.331.260', '1.296.075', '1.118.650'],
    ['Colombia', '48.321', '1000s', '2013', '0.0129', '45.803', '42.528', '32.657'],
    ['Comoros', '718', '1000s', '2012', '0.0247', '649', '570', '393'],
    ['Congo', '67.514', '1000s', '2013', '0.0275', '60.486', '52.487', '33.728'],
    ['Congo-Brazzaville', '4.448', '1000s', '2013', '0.0255', '3.995', '3.449', '2.32'],
    ['Costa Rica', '4.872', '1000s', '2013', '0.0139', '4.601', '4.246', '3.001'],
    ['Croatia', '4.253', '1000s', '2013', '-0.0035', '4.429', '4.439', '4.767'],
    ['Cuba', '11.266', '1000s', '2013', '-0.0005', '11.289', '11.273', '10.504'],
    ['Cyprus', '1.141', '1000s', '2013', '0.0108', '1.091', '1.016', '751'],
    ['Czech Republic', '10.521', '1000s', '2013', '0.0010', '10.444', '10.197', '10.361'],
    ['Denmark', '5.614', '1000s', '2013', '0.0040', '5.523', '5.405', '5.133'],
    ['Djibouti', '873', '1000s', '2013', '0.0154', '822', '766', '560'],
    ['Dominica', '72', '1000s', '2013', '0.0045', '71', '70', '71'],
    ['Dominican Republic', '10.404', '1000s', '2013', '0.0124', '9.884', '9.207', '7.099'],
    ['Ecuador', '15.492', '1000s', '2012', '0.0161', '14.512', '13.28', '9.651'],
    ['Egypt', '82.056', '1000s', '2013', '0.0165', '76.775', '70.591', '55.207'],
    ['El Salvador', '6.34', '1000s', '2013', '0.0068', '6.183', '6.05', '5.269'],
    ['Equatorial Guinea', '757', '1000s', '2013', '0.0281', '677', '586', '362'],
    ['Eritrea', '6.333', '1000s', '2013', '0.0330', '5.558', '4.666', '3.21'],
    ['Estonia', '1.325', '1000s', '2013', '-0.0003', '1.335', '1.363', '1.568'],
    ['Ethiopia', '94.101', '1000s', '2013', '0.0259', '84.838', '74.066', '46.435'],
    ['Fiji', '881', '1000s', '2013', '0.0072', '852', '819', '724'],
    ['Finland', '5.439', '1000s', '2013', '0.0047', '5.339', '5.228', '4.964'],
    ['France', '66.028', '1000s', '2013', '0.0054', '64.703', '62.702', '58.114'],
    ['Gabon', '1.672', '1000s', '2013', '0.0240', '1.519', '1.347', '921'],
    ['Gambia', '1.849', '1000s', '2013', '0.0324', '1.628', '1.392', '881'],
    ['Georgia', '4.477', '1000s', '2013', '-0.0031', '4.411', '4.318', '4.803'],
    ['Germany', '80.622', '1000s', '2013', '0.0024', '81.902', '82.516', '78.751'],
    ['Ghana', '25.905', '1000s', '2013', '0.0212', '23.692', '20.836', '14.233'],
    ['Greece', '11.032', '1000s', '2013', '-0.0054', '11.187', '11.056', '10.089'],
    ['Grenada', '106', '1000s', '2013', '0.0039', '104', '103', '97'],
    ['Guatemala', '15.468', '1000s', '2013', '0.0256', '13.989', '12.368', '8.688'],
    ['Guinea', '11.745', '1000s', '2013', '2.57', '10.593', '9.38', '5.751'],
    ['Guinea-Bissau', '1.704', '1000s', '2013', '0.0245', '1.551', '1.391', '995'],
    ['Guyana', '800', '1000s', '2013', '0.0053', '781', '757', '728'],
    ['Haiti', '10.317', '1000s', '2013', '0.0141', '9.765', '9.13', '6.965'],
    ['Honduras', '8.098', '1000s', '2013', '0.0204', '7.47', '6.762', '4.767'],
    ['Hong Kong', '7.188', '1000s', '2013', '0.0046', '6.973', '6.784', '5.686'],
    ['Hungary', '9.897', '1000s', '2013', '-0.0023', '10.023', '10.107', '10.482'],
    ['Iceland', '323', '1000s', '2013', '0.0071', '318', '292', '253'],
    ['India', '1.252.140', '1000s', '2013', '0.0125', '1.190.138', '1.110.626', '851.375'],
    ['Indonesia', '249.866', '1000s', '2013', '0.0122', '237.487', '221.294', '175.461'],
    ['Iran', '77.447', '1000s', '2013', '0.0134', '73.543', '69.342', '54.938'],
    ['Iraq', '33.417', '1000s', '2013', '0.0258', '30.163', '26.674', '17.074'],
    ['Ireland', '4.595', '1000s', '2013', '0.0018', '4.535', '4.07', '3.511'],
    ['Israel', '8.059', '1000s', '2013', '0.0188', '7.486', '6.809', '4.518'],
    ['Italy', '59.831', '1000s', '2013', '0.0049', '59.095', '57.685', '56.672'],
    ['Ivory Coast', '20.316', '1000s', '2013', '0.0240', '18.601', '17.144', '11.711'],
    ['Jamaica', '2.715', '1000s', '2013', '0.0027', '2.681', '2.634', '2.375'],
    ['Japan', '127.339', '1000s', '2013', '-0.0017', '127.558', '127.761', '123.116'],
    ['Jordan', '6.459', '1000s', '2013', '0.0223', '5.915', '5.29', '3.056'],
    ['Kazakhstan', '17.038', '1000s', '2013', '0.0147', '16.093', '15.013', '16.25'],
    ['Kenya', '44.354', '1000s', '2013', '0.0272', '39.825', '34.835', '22.667'],
    ['Kiribati', '102', '1000s', '2013', '0.0155', '96', '89', '69'],
    ['Kosovo', '1.824', '1000s', '2013', '0.0093', '1.761', '1.705', '1.827'],
    ['Kuwait', '3.369', '1000s', '2013', '0.0363', '2.85', '2.196', '2.059'],
    ['Kyrgyzstan', '5.72', '1000s', '2013', '0.0200', '5.383', '5.105', '4.308'],
    ['Laos', '6.77', '1000s', '2013', '0.0186', '6.268', '5.699', '4.123'],
    ['Latvia', '2.013', '1000s', '2013', '-0.0103', '2.142', '2.263', '2.667'],
    ['Lebanon', '4.467', '1000s', '2013', '0.0096', '4.247', '3.854', '2.677'],
    ['Lesotho', '2.074', '1000s', '2013', '0.0112', '1.99', '1.912', '1.57'],
    ['Liberia', '4.294', '1000s', '2013', '0.0247', '3.821', '3.185', '2.137'],
    ['Libya', '6.202', '1000s', '2013', '0.0076', '5.964', '5.507', '4.161'],
    ['Lithuania', '2.956', '1000s', '2013', '-0.0106', '3.163', '3.377', '3.684'],
    ['Luxembourg', '543', '1000s', '2013', '0.0231', '498', '458', '377'],
    ['Macedonia', '2.107', '1000s', '2013', '0.0008', '2.101', '2.086', '2.006'],
    ['Madagascar', '22.925', '1000s', '2013', '0.0283', '20.496', '17.763', '11.206'],
    ['Malawi', '16.363', '1000s', '2013', '0.0287', '14.573', '12.569', '9.105'],
    ['Malaysia', '29.717', '1000s', '2013', '0.0163', '27.79', '25.365', '17.707'],
    ['Maldives', '345', '1000s', '2013', '0.0194', '320', '293', '210'],
    ['Mali', '15.302', '1000s', '2013', '0.0302', '13.559', '11.573', '7.826'],
    ['Malta', '423', '1000s', '2013', '0.0091', '412', '401', '351'],
    ['Mauritania', '3.89', '1000s', '2013', '0.0247', '3.516', '3.055', '1.969'],
    ['Mauritius', '1.296', '1000s', '2013', '0.0040', '1.275', '1.233', '1.049'],
    ['Mexico', '122.332', '1000s', '2013', '0.0123', '116.423', '109.382', '84.327'],
    ['Moldova', '3.559', '1000s', '2013', '-0.0001', '3.566', '3.604', '3.681'],
    ['Mongolia', '2.839', '1000s', '2013', '0.0152', '2.672', '2.496', '2.141'],
    ['Montenegro', '621', '1000s', '2013', '0.0005', '619', '615', '612'],
    ['Morocco', '33.008', '1000s', '2013', '0.0150', '31.277', '29.856', '24.212'],
    ['Mozambique', '25.834', '1000s', '2013', '0.0250', '23.361', '20.439', '13.395'],
    ['Myanmar', '53.259', '1000s', '2013', '0.0087', '51.54', '49.875', '41.445'],
    ['Namibia', '2.303', '1000s', '2013', '0.0194', '2.143', '2.003', '1.361'],
    ['Nepal', '27.797', '1000s', '2013', '0.0118', '26.545', '24.922', '17.68'],
    ['Netherlands', '16.804', '1000s', '2013', '0.0029', '16.53', '16.282', '14.849'],
    ['New Zealand', '4.471', '1000s', '2013', '0.0085', '4.316', '4.088', '3.299'],
    ['Nicaragua', '6.08', '1000s', '2013', '0.0148', '5.743', '5.386', '4.046'],
    ['Niger', '17.831', '1000s', '2013', '0.0393', '15.303', '12.709', '7.52'],
    ['Nigeria', '173.615', '1000s', '2013', '0.0283', '155.381', '135.999', '93.18'],
    ['North Korea', '24.895', '1000s', '2013', '0.0053', '24.372', '23.639', '19.895'],
    ['Norway', '5.084', '1000s', '2013', '0.0131', '4.829', '4.592', '4.227'],
    ['Oman', '3.632', '1000s', '2013', '0.0961', '2.663', '2.464', '1.743'],
    ['Pakistan', '182.143', '1000s', '2013', '0.0166', '170.094', '155.151', '107.865'],
    ['Panama', '3.864', '1000s', '2013', '0.0163', '3.616', '3.303', '2.435'],
    ['Papua New Guinea', '7.321', '1000s', '2013', '0.0215', '6.705', '5.948', '4.057'],
    ['Paraguay', '6.802', '1000s', '2013', '0.0172', '6.347', '5.793', '4.139'],
    ['Peru', '30.376', '1000s', '2013', '0.0129', '28.934', '27.404', '21.326'],
    ['Philippines', '98.394', '1000s', '2013', '0.0174', '91.886', '84.231', '60.41'],
    ['Poland', '38.531', '1000s', '2013', '-0.0001', '38.152', '38.182', '37.962'],
    ['Portugal', '10.46', '1000s', '2013', '-0.0052', '10.568', '10.484', '10.005'],
    ['Qatar', '2.169', '1000s', '2013', '0.0576', '1.564', '720', '463'],
    ['Romania', '19.964', '1000s', '2013', '-0.0056', '20.367', '21.452', '23.161'],
    ['Russia', '143.5', '1000s', '2013', '0.0022', '141.909', '143.821', '147.721'],
    ['Rwanda', '11.777', '1000s', '2013', '0.0278', '10.53', '9.254', '7.224'],
    ['Saint Kitts and Nevis', '54', '1000s', '2013', '0.0113', '52', '48', '41'],
    ['Saint Lucia', '182', '1000s', '2013', '0.0078', '175', '163', '136'],
    ['Saint Vincent and the Grenadines', '109', '1000s', '2013', '0.0000', '109', '109', '107'],
    ['Samoa', '190', '1000s', '2013', '0.0079', '185', '179', '162'],
    ['San Marino', '31', '1000s', '2013', '0.0064', '31', '29', '24'],
    ['Sao Tome and Principe', '193', '1000s', '2013', '0.0260', '173', '151', '115'],
    ['Saudi Arabia', '28.829', '1000s', '2013', '0.0191', '26.796', '23.839', '15.665'],
    ['Senegal', '14.133', '1000s', '2013', '0.0297', '12.587', '10.968', '7.285'],
    ['Serbia', '7.164', '1000s', '2013', '-0.0049', '7.321', '7.463', 'n.a.'],
    ['Seychelles', '89', '1000s', '2013', '0.0099', '87', '82', '69'],
    ['Sierra Leone', '6.092', '1000s', '2013', '0.0190', '5.641', '4.928', '3.993'],
    ['Singapore', '5.399', '1000s', '2013', '0.0163', '4.988', '4.167', '2.931'],
    ['Slovak Republic', '5.414', '1000s', '2013', '0.0012', '5.386', '5.372', '5.276'],
    ['Slovenia', '2.06', '1000s', '2013', '0.0016', '2.04', '1.997', '1.996'],
    ['Solomon Islands', '561', '1000s', '2013', '0.0212', '515', '458', '303'],
    ['Somalia', '10.496', '1000s', '2013', '0.0295', '9.381', '8.25', '6.285'],
    ['South Africa', '52.982', '1000s', '2013', '0.0135', '50.223', '47.019', '34.491'],
    ['South Korea', '50.22', '1000s', '2013', '0.0043', '49.182', '48.039', '42.449'],
    ['South Sudan', '11.296', '1000s', '2013', '0.0423', '9.521', '7.73', '5.775'],
    ['Spain', '46.647', '1000s', '2013', '-0.0024', '46.363', '42.922', '38.791'],
    ['Sri Lanka', '20.483', '1000s', '2013', '0.0076', '20.45', '19.435', '16.825'],
    ['Sudan', '37.964', '1000s', '2013', '0.0207', '34.853', '30.779', '19.295'],
    ['Suriname', '539', '1000s', '2013', '0.0089', '520', '493', '400'],
    ['Swaziland', '1.25', '1000s', '2013', '0.0151', '1.174', '1.095', '834'],
    ['Sweden', '9.593', '1000s', '2013', '0.0077', '9.299', '8.994', '8.493'],
    ['Switzerland', '8.081', '1000s', '2013', '0.0106', '7.744', '7.39', '6.647'],
    ['Syria', '22.846', '1000s', '2013', '0.0199', '21.032', '17.676', '12.088'],
    ['Tajikistan', '8.208', '1000s', '2013', '0.0248', '7.447', '6.664', '5.16'],
    ['Tanzania', '49.253', '1000s', '2013', '0.0308', '43.64', '37.765', '24.686'],
    ['Thailand', '67.011', '1000s', '2013', '0.0034', '66.277', '65.087', '55.833'],
    ['The Bahamas', '377', '1000s', '2013', '0.0146', '354', '322', '252'],
    ['Timor-Leste', '1.178', '1000s', '2013', '0.0255', '1.049', '967', '730'],
    ['Togo', '6.817', '1000s', '2013', '0.0262', '6.144', '5.398', '3.685'],
    ['Tonga', '105', '1000s', '2013', '0.0036', '104', '100', '95'],
    ['Trinidad and Tobago', '1.341', '1000s', '2013', '0.0028', '1.323', '1.29', '1.214'],
    ['Tunisia', '10.886', '1000s', '2013', '0.0101', '10.44', '9.932', '7.959'],
    ['Turkey', '74.933', '1000s', '2013', '0.0126', '71.241', '66.846', '53.066'],
    ['Turkmenistan', '5.24', '1000s', '2013', '0.0130', '4.979', '4.697', '3.571'],
    ['Tuvalu', '10', '1000s', '2013', '0.0016', '10', '10', '9'],
    ['UAE', '9.346', '1000s', '2013', '0.0153', '7.718', '3.659', '1.707'],
    ['Uganda', '37.579', '1000s', '2013', '0.0339', '32.864', '27.767', '16.923'],
    ['UK', '64.097', '1000s', '2013', '0.0063', '62.276', '59.988', '57.077'],
    ['Ukraine', '45.49', '1000s', '2013', '-0.0023', '46.053', '47.452', '51.773'],
    ['Uruguay', '3.407', '1000s', '2013', '0.0035', '3.36', '3.324', '3.089'],
    ['USA', '316.129', '1000s', '2013', '0.0072', '306.772', '292.805', '246.819'],
    ['Uzbekistan', '30.241', '1000s', '2013', '0.0157', '27.767', '25.864', '20.077'],
    ['Vanuatu', '253', '1000s', '2013', '0.0222', '231', '204', '143'],
    ['Venezuela', '30.405', '1000s', '2013', '0.0150', '28.583', '26.261', '19.256'],
    ['Vietnam', '89.709', '1000s', '2013', '0.0105', '86.025', '81.438', '64.774'],
    ['Yemen', '24.407', '1000s', '2013', '0.0233', '22.23', '19.613', '11.27'],
    ['Zambia', '14.539', '1000s', '2013', '0.0329', '12.825', '11.175', '7.647'],
    ['Zimbabwe', '14.15', '1000s', '2013', '0.0310', '12.889', '12.693', '10.167'],
    ['Zimbabwe', '14.15', '1000s', '2013', '0.0310', '12.889', '12.693', '10.167']
  ];
};

export function getPersonalData() {
  return [
    ['', 'JAN', 'FEB', 'MAR', 'APR', 'MAY', 'JUN', 'JUL', 'AUG', 'SEP', 'OCT', 'NOV', 'DEC', 'Total'],
    ['Total Incomes', '=SUM(B7:B12)', '=SUM(C7:C12)', '=SUM(D7:D12)', '=SUM(E7:E12)', 
    '=SUM(F7:F12)', '=SUM(G7:G12)', '=SUM(H7:H12)', '=SUM(I7:I12)', '=SUM(J7:J12)', '=SUM(K7:K12)', 
    '=SUM(L7:L12)', '=SUM(M7:M12)', '=SUM(B2:M2)'],
    ['Total Expenses', '=SUM(B17:B43)', '=SUM(C17:C43)', '=SUM(D17:D43)', '=SUM(E17:E43)', 
    '=SUM(F17:F43)', '=SUM(G17:G43)', '=SUM(H17:H43)', '=SUM(I17:I43)', '=SUM(J17:J43)', 
    '=SUM(K17:K43)', '=SUM(L17:L43)', '=SUM(M17:M43)', '=SUM(B3:M3)'],
    ['NET (Income - Expenses)', '=B2-B3', '=C2-C3', '=D2-D3', '=E2-E3', '=F2-F3', '=G2-G3', 
    '=H2-H3', '=I2-I3', '=J2-J3', '=K2-K3', '=L2-L3', '=M2-M3', '=N2-N3', ''],
    ['', '', '', '', '', '', '', '', '', '', '', '', '', ''],
    ['Income', '', '', '', '', '', '', '', '', '', '', '', '', ''],
    ['Salary', 11370, 11370, 11370, 11370, 11370, 11370, 11370, 11370, 11370, 11370, 11370, 11370, ''],
    ['Interest income', 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, ''],
    ['Public assistance', '-  ', '-  ', '-  ', '-  ', '-  ', '-  ', '-  ', '-  ', '-  ', '-  ', '-  ', '-  ', ''],
    ['Dividends', '-  ', '-  ', '-  ', '-  ', '-  ', '-  ', '-  ', '-  ', '-  ', '-  ', '-  ', '-  ', ''],
    ['Gifts', 300, 300, 300, 300, 300, 300, 300, 300, 300, 300, 300, 300, ''],
    ['Other', 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, ''],
    ['', '', '', '', '', '', '', '', '', '', '', '', '', ''],
    ['Expenses', '', '', '', '', '', '', '', '', '', '', '', '', ''],
    ['Living', '', '', '', '', '', '', '', '', '', '', '', '', ''],
    ['', '', '', '', '', '', '', '', '', '', '', '', '', ''],
    ['Rent/Mortgage', 3200, 3200, 3200, 3200, 3200, 3200, 3200, 3200, 3200, 3200, 3200, 3200, ''],
    ['Electricity', 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, ''],
    ['Water/Gas/Sewer', 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, ''],
    ['TV/Internet/Phone', 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, ''],
    ['Maintenance', 260, 260, 260, 260, 260, 260, 260, 260, 260, 260, 260, 260, ''],
    ['Obligations', '', '', '', '', '', '', '', '', '', '', '', '', ''],
    ['', '', '', '', '', '', '', '', '', '', '', '', '', ''],
    ['Loans', 1500, 1500, 1500, 1500, 1500, 1500, 1500, 1500, 1500, 1500, 1500, 1500, ''],
    ['Credit cards', 120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120, ''],
    ['Taxes', '450', '450', '450', '450', '450', '450', '450', '450', '450', '450', '450', '450', ''],
    ['Insurance', '140', '140', '140', '140', '140', '140', '140', '140', '140', '140', '140', '140', ''],
    ['Daily expenses', '', '', '', '', '', '', '', '', '', '', '', '', ''],
    ['', '', '', '', '', '', '', '', '', '', '', '', '', ''],
    ['Food', 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, ''],
    ['Clothing', 350, 350, 350, 350, 350, 350, 350, 350, 350, 350, 350, 350, ''],
    ['Personal supplies', 120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120, ''],
    ['Health care', 320, 320, 320, 320, 320, 320, 320, 320, 320, 320, 320, 320, ''],
    ['Education', 540, 540, 540, 540, 540, 540, 540, 540, 540, 540, 540, 540, ''],
    ['Entertainment', 210, 210, 210, 210, 210, 210, 210, 210, 210, 210, 210, 210, ''],
    ['Transportation', 220, 220, 220, 220, 220, 220, 220, 220, 220, 220, 220, 220, ''],
    ['Other', '', '', '', '', '', '', '', '', '', '', '', '', ''],
    ['', '', '', '', '', '', '', '', '', '', '', '', '', ''],
    ['Donations', 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, ''],
    ['Savings', 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, ''],
    ['Gifts', 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, ''],
    ['Retirement', 800, 800, 800, 800, 800, 800, 800, 800, 800, 800, 800, 800, ''],
    ['Other', 150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 150, '']
  ];
};

export function getScienceData() {
  return [
    [`<div><a href="https://plot.ly/~JStevens/0/" 
    target="_blank" title="An Age Distribution for Scientific Genius" style="display: block; text-align: center;">
    <img src="https://plot.ly/~JStevens/0.png" alt="An Age Distribution for Scientific Genius" 
    style="max-width: 100%;width: 600px;"  width="600" 
    onerror="this.onerror=null;this.src="\'https://plot.ly/404.png\'";" /></a>
    <script data-plotly="JStevens:0" src="https://plot.ly/embed.js" async/></div>`,
     0.0008686210640608003, 18.235294117647058, 0.0015472312703583065, 18.235294117647058],
    ['', 0.0013436482084690554, 18.96551724137931, 0.002219055374592834, 18.843813387423936],
    ['', 0.0019408251900108608, 19.69574036511156, 0.0031867535287730727, 19.391480730223122],
    ['', 0.0025651465798045606, 20.425963488843813, 0.004153094462540717, 20.073022312373226],
    ['', 0.0034337676438653607, 21.03448275862069, 0.004987785016286645, 20.669371196754565],
    ['', 0.004352153456387986, 21.460446247464503, 0.006317861020629753, 21.399594320486816],
    ['', 0.00521172638436482, 21.82555780933063, 0.0069625407166123785, 21.764705882352942],
    ['', 0.006152732537097358, 22.190669371196755, 0.008170466883821935, 22.251521298174442],
    ['', 0.007229460731089401, 22.55578093306288, 0.008794788273615637, 22.616632860040568],
    ['', 0.008387622149837135, 22.920892494929006, 0.010173724212812157, 22.920892494929006],
    ['', 0.009373868982989511, 23.28600405679513, 0.010749185667752443, 23.164300202839755],
    ['', 0.01029677886355411, 23.651115618661258, 0.012061165399927623, 23.529411764705884],
    ['', 0.011156351791530943, 24.016227180527384, 0.012703583061889253, 23.772819472616632],
    ['', 0.012228555917481, 24.381338742393506, 0.014026872964169382, 24.04665314401623],
    ['', 0.01296145494028231, 24.685598377281945, 0.014712269272529858, 24.259634888438136],
    ['', 0.014060803474484256, 24.989858012170387, 0.01604234527687297, 24.527383367139958],
    ['', 0.015228013029315961, 25.35496957403651, 0.01685667752442997, 24.746450304259632],
    ['', 0.016270358306188927, 25.65922920892495, 0.018159609120521177, 25.020283975659225],
    ['', 0.01738599348534202, 25.963488843813387, 0.01881107491856678, 25.233265720081135],
    ['', 0.018611563517915312, 26.3894523326572, 0.020199511400651467, 25.50709939148073],
    ['', 0.01980456026058632, 26.69371196754564, 0.02092833876221498, 25.72008113590264],
    ['', 0.020863192182410423, 26.937119675456387, 0.022190553745928338, 26.024340770791074],
    ['', 0.022339847991313787, 27.302231237322516, 0.022923452768729643, 26.3894523326572],
    ['', 0.023452768729641693, 27.72819472616633, 0.02438925081433225, 26.754563894523326],
    ['', 0.024267100977198697, 27.91075050709939, 0.025868621064060807, 27.18052738336714],
    ['', 0.0254343105320304, 28.154158215010142, 0.026673905175533846, 27.545638945233264],
    ['', 0.026302931596091206, 28.45841784989858, 0.02776872964169381, 27.789046653144013],
    ['', 0.027280130293159614, 28.76267748478702, 0.028574918566775243, 27.971602434077077],
    ['', 0.028338762214983715, 29.12778904665314, 0.03022801302931596, 28.3367139959432],
    ['', 0.02915309446254072, 29.43204868154158, 0.03102605863192183, 28.640973630831645],
    ['', 0.030103148751357223, 29.73630831643002, 0.03213219326818676, 28.945233265720077],
    ['', 0.031351791530944625, 30.162271805273832, 0.03285830618892508, 29.310344827586206],
    ['', 0.03264169381107492, 30.563894523326567, 0.03405266015200869, 29.675456389452336],
    ['', 0.033819218241042344, 30.831643002028393, 0.03517915309446254, 30.162271805273832],
    ['', 0.03510314875135723, 31.075050709939145, 0.0362785016286645, 30.649087221095332],
    ['', 0.0362785016286645, 31.50101419878296, 0.037595005428881646, 31.379310344827587],
    ['', 0.037377850162866454, 31.74442190669371, 0.03866449511400652, 32.14604462474645],
    ['', 0.03853691639522258, 32.04868154158215, 0.03952768729641694, 32.7789046653144],
    ['', 0.0396742671009772, 32.535496957403645, 0.04090662323561346, 33.32657200811359],
    ['', 0.04063517915309446, 33.08316430020284, 0.04201954397394137, 33.935091277890464],
    ['', 0.04175488599348534, 33.75253549695741, 0.0430985342019544, 34.42190669371197],
    ['', 0.042345276872964174, 34.36105476673428, 0.04424538545059718, 35.030425963488845],
    ['', 0.04367535287730728, 34.908722109533464, 0.04480456026058634, 35.74847870182555],
    ['', 0.04432681867535289, 35.51724137931035, 0.04489685124864278, 36.49087221095334],
    ['', 0.044869706840390884, 36.21703853955374, 0.0445928338762215, 37.18458417849898],
    ['', 0.04497828447339849, 36.977687626774845, 0.04391965255157438, 37.76876267748479],
    ['', 0.04491042345276873, 37.7079107505071, 0.04318675352877307, 38.073022312373226],
    ['', 0.04453040173724213, 38.43813387423935, 0.042064784654361205, 38.681541582150096],
    ['', 0.04413680781758958, 39.04665314401622, 0.04071661237785017, 39.22920892494928],
    ['', 0.04325913861744481, 39.65517241379311, 0.03971226927252986, 39.59432048681541],
    ['', 0.042691368078175904, 40.26369168356999, 0.03815146579804561, 40.081135902636916],
    ['', 0.041564875135722046, 40.750507099391484, 0.03754071661237785, 40.324543610547664],
    ['', 0.040640608034744855, 41.17647058823529, 0.036074918566775256, 40.56795131845842],
    ['', 0.039603691639522265, 41.54158215010142, 0.03550488599348534, 40.811359026369175],
    ['', 0.03845457835685849, 41.90669371196754, 0.034229098805646035, 41.05476673427992],
    ['', 0.03749547593195802, 42.271805273833664, 0.033469055374592833, 41.23732251521298],
    ['', 0.03653637350705755, 42.63691683569979, 0.03219326818675353, 41.54158215010142],
    ['', 0.03528094462540717, 43.00202839756592, 0.031541802388707935, 41.78498985801217],
    ['', 0.03392508143322477, 43.294117647058826, 0.030266015200868624, 42.1501014198783],
    ['', 0.03285830618892509, 43.793103448275865, 0.02953311617806732, 42.454361054766736],
    ['', 0.031939920376402475, 44.21906693711968, 0.02833876221498372, 42.880324543610556],
    ['', 0.031202497285559173, 44.523326572008116, 0.027687296416938116, 43.1237322515213],
    ['', 0.03018458197611293, 44.888438133874246, 0.02635179153094463, 43.537525354969574],
    ['', 0.029207383279044517, 45.31440162271805, 0.025570032573289908, 44.2920892494929],
    ['', 0.028019815418023886, 45.740365111561864, 0.024723127035830628, 44.94929006085192],
    ['', 0.02687296416938111, 46.22718052738337, 0.02348534201954397, 45.801217038539555],
    ['', 0.025848262757871887, 46.713995943204864, 0.022638436482084696, 46.470588235294116],
    ['', 0.02484618168657256, 47.139959432048684, 0.021864820846905535, 47.20081135902637],
    ['', 0.02397394136807818, 47.62677484787018, 0.021186210640608032, 48.29614604462475],
    ['', 0.023127035830618894, 48.17444219066937, 0.020385450597176984, 48.884381338742386],
    ['', 0.022090119435396308, 48.722109533468554, 0.01935396308360478, 49.39148073022312],
    ['', 0.021208830980817946, 49.208924949290065, 0.018892508143322474, 49.69574036511156],
    ['', 0.02010722041259501, 49.63488843813387, 0.017695439739413687, 50.182555780933065],
    ['', 0.018914223669923996, 50.06085192697769, 0.016775244299674273, 50.66937119675457],
    ['', 0.01782844733984799, 50.42596348884381, 0.015662323561346364, 51.217038539553755],
    ['', 0.016924538545059722, 50.851926977687626, 0.014766558089033658, 51.76470588235294],
    ['', 0.016069489685124862, 51.27789046653144, 0.014026872964169382, 52.2210953346856],
    ['', 0.014854777415852324, 51.70385395537525, 0.01319218241042345, 52.73833671399595],
    ['', 0.013802931596091209, 52.06896551724138, 0.0126900108577633, 53.40770791075052],
    ['', 0.012866449511400656, 52.4340770791075, 0.011543159609120526, 54.259634888438136],
    ['', 0.011909609120521171, 52.92089249492901, 0.010830618892508146, 54.62474645030425],
    ['', 0.010939196525515747, 53.40770791075051, 0.009636264929424545, 55.233265720081135],
    ['', 0.009853420195439734, 54.01622718052738, 0.008631921824104228, 55.841784989858006],
    ['', 0.008794788273615635, 54.74645030425964, 0.007980456026058637, 56.57200811359027],
    ['', 0.008102605863192176, 55.476673427991884, 0.007471498371335507, 57.3630831643002],
    ['', 0.007247557003257327, 56.206896551724135, 0.0068675352877307265, 57.97160243407708],
    ['', 0.006824104234527677, 56.8762677484787, 0.005822475570032569, 59.00608519269776],
    ['', 0.006487513572204123, 57.66734279918864, 0.005028501628664499, 59.73630831643002],
    ['', 0.00635179153094463, 58.39756592292089, 0.004424538545059723, 60.46653144016227],
    ['', 0.006039630836047772, 59.12778904665315, 0.00386807817589576, 61.25760649087221],
    ['', 0.005646036916395228, 59.85801217038539, 0.0036807817589576634, 61.86612576064908],
    ['', 0.005266015200868617, 60.58823529411764, 0.003583061889250809, 62.657200811359026],
    ['', 0.004869706840390869, 61.28194726166329, 0.0035152008686210575, 63.38742393509127],
    ['', 0.004356677524429961, 62.04868154158215, 0.0034201954397394163, 63.87423935091278],
    ['', 0.003778501628664497, 62.718052738336716, 0.0030537459283387597, 64.84787018255577],
    ['', 0.0030673181324647083, 63.50912778904665, 0.0030401737242128205, 65.39553752535497],
    ['', 0.002671009771986973, 64.27586206896551, 0.0027823018458197645, 66.30831643002028],
    ['', 0.002497285559174807, 64.96957403651115, 0.002605863192182404, 66.91683569979716],
    ['', 0.002263843648208466, 65.63894523326572, 0.0023615635179153054, 67.89046653144015],
    ['', 0.001940825190010856, 66.43002028397567, 0.0022801302931596138, 68.49898580121703],
    ['', 0.001872964169381108, 67.16024340770792, 0.002212269272529848, 69.47261663286005],
    ['', 0.0017915309446254028, 67.89046653144015, 0.0021986970684039126, 70.08113590263692],
    ['', 0.0017263843648208464, 68.55983772819474, 0.0019951140065146587, 71.05476673427991],
    ['', 0.0015472312703583106, 69.5943204868154, 0.0018526058631921807, 71.6632860040568],
    ['', 0.0014522258414766567, 70.32454361054766, 0.0017589576547231214, 72.57606490872212],
    ['', 0.001180781758957652, 71.05476673427992, 0.0015472312703582996, 73.30628803245436],
    ['', 0.000950054288816508, 71.78498985801217, 0.0014250814332247598, 74.0973630831643],
    ['', 0.000665038002171552, 72.51521298174443, null, null],
    ['', 0.0005157437567861012, 73.24543610547667, null, null],
    ['', 0.0004275244299674336, 73.85395537525355, null, null]
  ];
};

export function getSportData() {
  return [
    [1, 'Los Angeles Lakers', '<img src="assets/images/lakers.gif">', '2600', '0.93', '0.02', '293', '104.1'],
    [2, 'New York Knicks', '<img src="assets/images/knicks.gif">', '2500', '0.79', '0.00', '278', '53.4'],
    [3, 'Chicago Bulls', '<img src="assets/images/bulls.gif">', '2000', '0.100', '0.03', '201', '65.3'],
    [4, 'Boston Celtics', '<img src="assets/images/celtic.gif">', '1700', '0.94', '0.09', '173', '54.9'],
    [5, 'Los Angeles Clippers', '<img src="assets/images/clippers.gif">', '1600', '0.178', '0.00', '146', '20.1'],
    [6, 'Brooklyn Nets', '<img src="assets/images/nets.gif">', '1500', '0.92', '0.019', '212', '-99.4'],
    [8, 'Houston Rockets', '<img src="assets/images/rockets.gif">', '1250', '0.61', '0.08', '175', '38'],
    [9, 'Miami Heat', '<img src="assets/images/heat.gif">', '1175', '0.53', '0.08', '188', '12.6'],
    [10, 'Dallas Mavericks', '<img src="assets/images/mavericks.gif">', '1150', '0.50', '0.017', '168', '30.4'],
    [11, 'San Antonio Spurs', '<img src="assets/images/spurs.gif">', '1000', '0.52', '0.08', '172', '40.9'],
    [12, 'Portland Trail Blazers', '<img src="assets/images/blazers.gif">', '940', '0.60', '0.011', '153', '11.7'],
    [13, 'Oklahoma City Thunder', '<img src="assets/images/thunder.gif">', '930', '0.58', '0.015', '152', '30.8'],
    [14, 'Toronto Raptors', '<img src="assets/images/raptors.gif">', '920', '0.77', '0.016', '151', '17.9'],
    [15, 'Cleveland Cavaliers', '<img src="assets/images/cavaliers.gif">', '915', '0.78', '0.022', '149', '20.6'],
    [16, 'Phoenix Suns', '<img src="assets/images/suns.gif">', '910', '0.61', '0.020', '145', '28.2'],
    [17, 'Washington Wizards', '<img src="assets/images/wizards.gif">', '900', '0.86', '0.014', '143', '10.1'],
    [18, 'Orlando Magic', '<img src="assets/images/magic.gif">', '875', '0.56', '0.017', '143', '20.9'],
    [19, 'Denver Nuggets', '<img src="assets/images/nuggets.gif">', '855', '0.73', '0.01', '136', '14'],
    [20, 'Utah Jazz', '<img src="assets/images/jazz.gif">', '850', '0.62', '0.06', '142', '32.7'],
    [21, 'Indiana Pacers', '<img src="assets/images/pacers.gif">', '830', '0.75', '0.018', '139', '25'],
    [22, 'Atlanta Hawks', '<img src="assets/images/hawks.gif">', '825', '0.94', '0.021', '133', '14.8'],
    [23, 'Detroit Pistons', '<img src="assets/images/pistons.gif">', '810', '0.80', '0.023', '144', '17.6'],
    [24, 'Sacramento Kings', '<img src="assets/images/kings.gif">', '800', '0.45', '0.029', '125', '8.9'],
    [25, 'Memphis Grizzlies', '<img src="assets/images/memphis.gif">', '750', '0.66', '0.023', '135', '10.5'],
    [26, 'Charlotte Hornets', '<img src="assets/images/hornets.gif">', '725', '0.77', '0.021', '130', '1.2'],
    [27, 'Philadelphia 76ers', '<img src="assets/images/76ers.gif">', '700', '0.49', '0.021', '125', '24.4'],
    [28, 'New Orleans Pelicans', '<img src="assets/images/orleans.gif">', '650', '0.55', '0.019', '131', '19'],
    [29, 'Minnesota Timberwolves', '<img src="assets/images/timberwolves.gif">', '625', '0.45', '0.016', '128', '6.9'],
    [30, 'Milwaukee Bucks', '<img src="assets/images/bucks.gif">', '600', '0.48', '0.029', '110', '11.5']
  ];
};

export function getFinanceData() {
  return [
    ['239.65', '24/02/2015', '0.000128', '-0.2379', '47.044'],
    ['238.99', '24/02/2015', '0.0106', '-0.2435', '5.11'],
    ['231.26', '24/02/2015', '0.0066', '-0.2521', '7.571'],
    ['239.12', '24/02/2015', '0.0082', '-0.2454', '16.429'],
    ['255.07', '24/02/2015', '0.0091', '-0.2017', '252'],
    ['238.91', '24/02/2015', '0.0077', '-0.2437', '995'],
    ['211.51', '24/02/2015', '0.0089', '-0.1880', '4.28'],
    ['210.65', '24/02/2015', '0.0078', '-0.1930', '2.521'],
    ['205.06', '24/02/2015', '0.0107', '-0.2251', '96'],
    ['212.41', '24/02/2015', '0.0085', '-0.1949', '456'],
    ['227.94', '24/02/2015', '0.0158', '-0.1363', '49'],
    ['211.28', '24/02/2015', '0.0078', '-0.1765', '19'],
    ['1486.97', '24/02/2015', '0.0112', '-0.2310', '168'],
    ['1310.00', '24/02/2015', '-0.01812', '-0.3310', '0'],
    ['1497.50', '24/02/2015', '0.0051', '-0.2309', '160']
  ];
};
