# Pulse Unity Asset

This repository is a collection of assets designed to integrate the [Pulse Physiology Engine](https://pulse.kitware.com) within [Unity3D](https://unity3d.com/).

## Requirements

- **Unity**: version 2018.3
- **OS**: Windows 7 SP1+, 8, 10, 64-bit versions only; Ubuntu 12.04+, 64-bit versions only; macOS 10.11+
*Server versions of Windows & OS X are not tested.*
- **CPU**: SSE2 instruction set support.
- **GPU**: Graphics card with DX10 (shader model 4.0) capabilities.
> _System requirements taken on 13/02/2019 from: https://unity3d.com/unity/system-requirements_

## Installation

### From the Asset Store

The Pulse Unity Asset is available for download on the [Unity Asset Store](
http://u3d.as/1sp1).

### From a packaged release

Each release is associated with a [Unity Asset Package](https://docs.unity3d.com/Manual/AssetPackages.html) which can be downloaded from our [release page](https://gitlab.kitware.com/physiology/PulseUnityAsset/releases).

### From Git

#### Install Git LFS
This project uses Git LFS for data (.csv, .json state files) and binaries (libraries in `Plugins`), so ensure that [Git LFS is installed](https://git-lfs.github.com/) and that you've run `git lfs install`.

### Setup the repository inside your Unity project
To be able to access the Pulse Unity Asset, this whole repository needs to live somewhere under the `Assets` folder of your Unity project. For example:
```
YourProject/
  Assembly-CSharp-Editor.csproj
  Assembly-CSharp.csproj
  Assets/
    PulseUnityAsset/ <-- here
    ...
  Library/
  YourProject.sln
  obj/
  ProjectSettings/
  Temp/
  ...
```

Therefore:
```
cd YourProject/Assets
git clone https://gitlab.kitware.com/physiology/PulseUnityAsset
```

If `YourProject` is version-controlled with Git, you can add `PulseUnityAsset` as a submodule instead:
```bash
cd YourProject/Assets
git submodule add https://gitlab.kitware.com/physiology/PulseUnityAsset
```

#### Copy the `PulseDataFiles` in the top `StreamingAssets` directory
As explained in the [README](/PulsePhysiologyEngine/StreamingAssets/README.md) of the inner `StreamingAssets` directory - the `PulseDataFiles` directory needs to be copied inside the top level `StreamingAssets` directory, which can be done with the following command:
```bash
cp -r Assets/PulseUnityAsset/PulsePhysiologyEngine/StreamingAssets/PulseDataFiles Assets/StreamingAssets/
```

## How to use

The user manual needs to be embedded in the Unity asset package according to the Unity Asset Store submission guidelines ([section 3.2](https://unity3d.com/asset-store/sell-assets/submission-guidelines#content-organization)) and can therefore be found at
[`PulsePhysiologyEngine/Documentation/PulseUnityAssetUserManual.pdf`](/PulsePhysiologyEngine/Documentation/PulseUnityAssetUserManual.pdf)

## Pulse engine backend

Current version of Pulse engine: [REL_2_3_0](https://gitlab.kitware.com/physiology/engine/commits/REL_2_3_0)

### Plugins
Functionality from the C++ API of the Pulse engine are encapsulated in  the following [plugins](https://docs.unity3d.com/Manual/Plugins.html):
- **PulseC <sup>(native)</sup>:** a [C wrapper](https://gitlab.kitware.com/physiology/engine/tree/a5c408b/engine/c) for the Pulse engine
  - `.dll` for Windows
  - `.so` for Linux
  - `.dylib` for MacOS
- **PulseEngine.dll <sup>(managed)</sup>:** a [C# interface](https://gitlab.kitware.com/physiology/engine/tree/a5c408b/engine/csharp) to the Pulse engine implemented by wrapping PulseC
- **CommonDataModel.dll <sup>(managed)</sup>:** a [C# implementation](https://gitlab.kitware.com/physiology/engine/tree/a5c408b/cdm/csharp) of the [common data model](http://pulse.kitware.com/_c_d_m.html) 
- **DataModelBindings.dll <sup>(managed)</sup>:** C# bindings autogenerated by protobuf of the common data model [schema]( https://gitlab.kitware.com/physiology/engine/tree/a5c408b/schema/proto)
- **Google.Protobuf.dll <sup>(managed)</sup>:** C# library of [protocol-buffers](https://github.com/protocolbuffers/protobuf/tree/master/csharp/src/Google.Protobuf)

### Building the Pulse Asset plugins

The binaries/plugins above will be built along with the Pulse engine (steps [here](https://gitlab.kitware.com/physiology/engine#building)), noting that:
- The native plugins (`PulseC`) need to be built on **each of your target platforms**
- The managed plugins can **only be built on Windows** but will then support every target platform

## Limitations

### IL2CPP Build Support

The Pulse Unity Asset is not currently supported in Unity projects built with the [IL2CPP compiler](https://docs.unity3d.com/Manual/IL2CPP.html). The IL2CPP compiler performs [bytecode stripping](https://docs.unity3d.com/Manual/IL2CPP-BytecodeStripping.html) on the provided Pulse plugins (Google Protocol Buffers used in Pulse for serialization), which results in stripping of code that is actually necessary for Pulse.
The link.xml file (described below) can be used to effectively disable bytecode stripping by preserving both types and full assemblies.
```xml
<linker>
       <assembly fullname="System" preserve="all"/>
</linker>
```

Note that the IL2CPP AOT compiler may also error out when processing the provided `Google.Protobuf.dll` managed plugin. We are currently in touch with the Protobuf team to find a solution.

If you need to use the IL2CPP compiler and it is preventing you from integrating Pulse in your Unity application, you can find support on our [Discourse support forum](https://discourse.kitware.com/c/pulse-physiology-engine).

### Missing C++ functionality from the Pulse engine in the C# assets

The Pulse Unity Asset only exposes a portion of the functionality available in the C++ interface of the Pulse engine. If you need to expose more functionality from the C++ library in Unity, you need to:
1. Update the C and C# implementations [of the plugins listed above](#plugins). You can contribute those changes to the [Pulse engine repository](https://gitlab.kitware.com/physiology/engine/blob/master/CONTRIBUTING.md).
2. Build those plugins as described [above](#building-the-pulse-asset-plugins)
3. Update those files in the [Plugins](/PulsePhysiologyEngine/Plugins) directory. See the contribution guidelines [below](#contributing) to receive reviews and continuous support for your implementation.

If you are interested in collaborating with us to bring more of the Pulse engine functionality to Unity, you can contact us at kitware@kitware.com.

### Using a custom version/fork of PulseEngine?

Before we can bring any capabilities to the Pulse Unity Asset, they will need to be part of the Pulse Engine repository. You can contribute your changes [there](https://gitlab.kitware.com/physiology/engine/blob/master/CONTRIBUTING.md) to facilitate their integration to the Unity Asset in the future. If you need help designing a custom solution based on Pulse, you can contact us at kitware@kitware.com.

## Contributing

### Found a bug

Ask your questions and share your remarks in our issue tracker on GitLab: 
https://gitlab.kitware.com/physiology/PulseUnityAsset/issues

### Can't quite make it work?

You can find support on our [Discourse support forum](https://discourse.kitware.com/c/pulse-physiology-engine).

### Have a fix you'd like to contribute back?

You can follow this simple [forking workflow](https://docs.gitlab.com/ee/workflow/forking_workflow.html):
1. [Fork](https://docs.gitlab.com/ee/gitlab-basics/fork-project.html) this project in your own GitLab user or group
2. Commit the fix to a branch on top of `master`
3. Push the branch on your forked repository
4. Create a [merge request](https://docs.gitlab.com/ee/gitlab-basics/add-merge-request.html) in this repository
