/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#pragma once

#include <QObject>
#include <QDockWidget>
#include "controls/QPulse.h"

namespace Ui {
  class MultiTraumaShowcaseWidget;
}

class QMultiTraumaShowcaseWidget : public QDockWidget, public PulseListener
{
  Q_OBJECT
public:
  QMultiTraumaShowcaseWidget(QPulse& qp, QWidget *parent = Q_NULLPTR, Qt::WindowFlags flags = Qt::WindowFlags());
  virtual ~QMultiTraumaShowcaseWidget();

  bool ConfigurePulse(PhysiologyEngine& pulse, SEDataRequestManager& drMgr);

  void AtSteadyState(PhysiologyEngine& pulse) {}
  void AtSteadyStateUpdateUI() {} // Main Window will call this to update UI Components
  void ProcessPhysiology(PhysiologyEngine& pulse);
  void PhysiologyUpdateUI();// Main Window will call this to update UI Components

signals:
protected slots:
  void ApplyHemorrhage();
  void ApplyPneumothorax();
  void ApplyPressure();
  void ApplyNeedleDecompression();
  void ApplyTourniquet();
  void InfuseSaline();
  void InjectMorphine();

private:
  class Controls;
  Controls* m_Controls;

};