/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#pragma once

#include <QObject>
#include <QDockWidget>
#include "QPulse.h"

#include "PulsePhysiologyEngine.h"
#include "PulseScenario.h"

namespace Ui {
  class ScenarioEditorWidget;
}

enum class ScenarioInput { None = 0, State, Patient };
class QScenarioEditorWidget : public QDockWidget, public PulseListener
{
  Q_OBJECT
public:
  QScenarioEditorWidget(QPulse& qp, QWidget *parent = Q_NULLPTR, Qt::WindowFlags flags = Qt::WindowFlags());
  virtual ~QScenarioEditorWidget();

  void Reset();
  ScenarioInput LoadScenario(std::string const& scenario_file);

  void AtSteadyState(PhysiologyEngine& pulse) {}
  void AtSteadyStateUpdateUI() {} // Main Window will call this to update UI Components
  void ProcessPhysiology(PhysiologyEngine& pulse) {}
  void PhysiologyUpdateUI() {} // Main Window will call this to update UI Components


protected:
  void DisplayActions(const std::vector<const SEAction*>& actions);

private:
  class Controls;
  Controls* m_Controls;
  
};