/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#pragma once

#include <QObject>
#include <QDockWidget>
#include "QPulse.h"

class SEPatient;

namespace Ui {
  class PatientEditorWidget;
}

class QPatientEditorWidget : public QDockWidget, public PulseListener
{
  Q_OBJECT
public:
  QPatientEditorWidget(QPulse& qp, QWidget *parent = Q_NULLPTR, Qt::WindowFlags flags = Qt::WindowFlags());
  virtual ~QPatientEditorWidget();

  void Reset();
  void EnableInput(bool b);
  bool ValidPatient();
  void PatientToControls();
  void ControlsToPatient();

  void AtSteadyState(PhysiologyEngine& pulse);
  void AtSteadyStateUpdateUI(); // Main Window will call this to update UI Components
  void ProcessPhysiology(PhysiologyEngine& pulse) {}
  void PhysiologyUpdateUI() {}// Main Window will call this to update UI Components

protected:

protected slots:
  void UpdateUI();
  void ResetPatientControls();
  void LoadPatientFile();
  void SavePatientFile();
  void ShowAdvancedProperties();
  void SetStateFilename();

  void EnableConverter(bool b);

private:
  class Controls;
  Controls* m_Controls;
  
};