/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#pragma once

#include <QObject>
#include <QDockWidget>
#include "QPulse.h"

namespace Ui {
  class DynamicControlsWidget;
}

class QDynamicControlsWidget : public QDockWidget, public PulseListener
{
  Q_OBJECT
public:
  QDynamicControlsWidget(QPulse& qp, QWidget *parent = Q_NULLPTR, Qt::WindowFlags flags = Qt::WindowFlags());
  virtual ~QDynamicControlsWidget();

  void Reset();
  bool ValidPatient();

  bool SetupShowcase(QString name);
  bool SetupScenarioEditor();
  bool SetupEngineState();
  bool SetupPatientEditor();
  void PrepStabilization(InputMode m);
  void EngineToControls();

  void AtSteadyState(PhysiologyEngine& pulse);
  void AtSteadyStateUpdateUI(); // Main Window will call this to update UI Components
  void ProcessPhysiology(PhysiologyEngine& pulse);
  void PhysiologyUpdateUI();// Main Window will call this to update UI Components


private:
  class Controls;
  Controls* m_Controls;
  
};