/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#include "DataRequestViewWidget.h"
#include "ui_DataRequestView.h"

#include <QList>
#include <QLayout>
#include <QMdiArea>
#include <QMdiSubWindow>
#include "PlotSetWidget.h"

#include "cdm/CommonDataModel.h"
#include "PulsePhysiologyEngine.h"
#include "cdm/engine/SEEngineTracker.h"

class QDataRequestViewWidget::Controls : public Ui::DataRequestViewWidget
{
public:
  Controls(QPulse& qp) : Pulse(qp) {}
  QPulse&     Pulse;
};

QDataRequestViewWidget::QDataRequestViewWidget(QPulse& qp, QWidget *parent, Qt::WindowFlags flags) : QDockWidget(parent, flags)
{
  m_Controls = new Controls(qp);
  m_Controls->setupUi(this);

  m_Controls->TileButton->setEnabled(false);
  m_Controls->NewPlotSetButton->setEnabled(false);
  m_Controls->mdiArea->setOption(QMdiArea::DontMaximizeSubWindowOnActivation);

  qp.GetEngine().GetEngineTracker()->SetTrackMode(TrackMode::Dynamic);
  connect(m_Controls->NewPlotSetButton, SIGNAL(clicked()), SLOT(NewPlotSet()));
  connect(m_Controls->TileButton, SIGNAL(clicked()), SLOT(Tile()));
}

QDataRequestViewWidget::~QDataRequestViewWidget()
{
  Reset();
  delete m_Controls;
}

void QDataRequestViewWidget::Reset()
{
  while (m_Controls->mdiArea->subWindowList().size() > 0)
  {
    QMdiSubWindow* item = m_Controls->mdiArea->subWindowList().first();
    m_Controls->mdiArea->removeSubWindow(item);
    delete item;
  }
  m_Controls->TileButton->setEnabled(false);
  m_Controls->NewPlotSetButton->setEnabled(false);
}


void QDataRequestViewWidget::NewPlotSet()
{
  QPlotSetWidget* plotSet = new QPlotSetWidget(m_Controls->Pulse, this);
  plotSet->setTitleBarWidget(new QWidget());
  QMdiSubWindow* sub = m_Controls->mdiArea->addSubWindow(plotSet);
  sub->show();
  sub->setWindowFlags(windowFlags() ^ Qt::WindowMaximizeButtonHint);
  Tile();
}

void QDataRequestViewWidget::Tile()
{
  m_Controls->mdiArea->tileSubWindows();
}

void QDataRequestViewWidget::AtSteadyState(PhysiologyEngine& pulse)
{
  for (QMdiSubWindow* subwindow : m_Controls->mdiArea->subWindowList())
    ((QPlotSetWidget*)subwindow->widget())->AtSteadyState(pulse);
}
void QDataRequestViewWidget::AtSteadyStateUpdateUI()
{
  m_Controls->TileButton->setEnabled(true);
  m_Controls->NewPlotSetButton->setEnabled(true);
  for (QMdiSubWindow* subwindow : m_Controls->mdiArea->subWindowList())
    ((QPlotSetWidget*)subwindow->widget())->AtSteadyStateUpdateUI();
}

void QDataRequestViewWidget::ProcessPhysiology(PhysiologyEngine& pulse)
{// This is called from a thread, you should NOT update UI here
  // This is where we pull data from pulse, and push any actions to it

  pulse.GetEngineTracker()->TrackData();
  for (QMdiSubWindow* subwindow : m_Controls->mdiArea->subWindowList())
    ((QPlotSetWidget*)subwindow->widget())->ProcessPhysiology(pulse);
}

void QDataRequestViewWidget::PhysiologyUpdateUI()
{
  for (QMdiSubWindow* subwindow : m_Controls->mdiArea->subWindowList())
    ((QPlotSetWidget*)subwindow->widget())->PhysiologyUpdateUI();
}

