/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#include "ActionsEditorWidget.h"
#include "ui_ActionsEditor.h"
#include <QMessageBox>

#include "CollapsableWidget.h"

#include "actions/ActionWidget.h"
#include "actions/AcuteStressWidget.h"
#include "actions/AirwayObstructionWidget.h"
#include "actions/ApneaWidget.h"
#include "actions/AsthmaAttackWidget.h"
#include "actions/BronchoconstrictionWidget.h"
#include "actions/CardiacArrestWidget.h"
#include "actions/ChestCompressionForceScaleWidget.h"
#include "actions/ChestOcclusiveDressingWidget.h"
//#include "actions/ConsciousRespirationWidget.h"
#include "actions/ExerciseWidget.h"
#include "actions/HemorrhageWidget.h"
#include "actions/IntubationWidget.h"
#include "actions/NeedleDecompressionWidget.h"
#include "actions/PericardialEffusionWidget.h"
#include "actions/SubstanceBolusWidget.h"
#include "actions/SubstanceCompoundInfusionWidget.h"
#include "actions/SubstanceInfusionWidget.h"
#include "actions/SupplementalOxygenWidget.h"
#include "actions/TensionPneumothoraxWidget.h"

#include "cdm/CommonDataModel.h"
#include "cdm/PhysiologyEngine.h"
#include "cdm/engine/SEPatientConfiguration.h"
#include "cdm/engine/SEActionManager.h"
#include "cdm/engine/SEAction.h"
#include "cdm/patient/actions/SEAcuteStress.h"

class QActionsEditorWidget::Controls : public Ui::ActionsEditorWidget
{
public:
  Controls(QPulse& qp) : Pulse(qp) {}
  QPulse&                Pulse;

  QAcuteStressWidget*                            AcuteStress;
  QCollapsableWidget*                            CWAcuteStress;

  QAirwayObstructionWidget*                      AirwayObstruction;
  QCollapsableWidget*                            CWAirwayObstruction;

  QApneaWidget*                                  Apnea;
  QCollapsableWidget*                            CWApnea;

  QAsthmaAttackWidget*                           AsthmaAttack;
  QCollapsableWidget*                            CWAsthmaAttack;

  QBronchoconstrictionWidget*                    Bronchoconstriction;
  QCollapsableWidget*                            CWBronchoconstriction;

  QCardiacArrestWidget*                          CardiacArrest;
  QCollapsableWidget*                            CWCardiacArrest;

  QChestCompressionForceScaleWidget*             ChestCompressionForceScale;
  QCollapsableWidget*                            CWChestCompressionForceScale;

  QChestOcclusiveDressingWidget*                 ChestOcclusiveDressing;
  QCollapsableWidget*                            CWChestOcclusiveDressing;

  //QConsciousRespirationWidget*                   ConsciousRespiration;
  //QCollapsableWidget*                            CWConsciousRespiration;

  QExerciseWidget*                               Exercise;
  QCollapsableWidget*                            CWExercise;

  QHemorrhageWidget*                             Hemorrhage;
  QCollapsableWidget*                            CWHemorrhage;

  QIntubationWidget*                             Intubation;
  QCollapsableWidget*                            CWIntubation;

  QNeedleDecompressionWidget*                    NeedleDecompression;
  QCollapsableWidget*                            CWNeedleDecompression;

  QPericardialEffusionWidget*                    PericardialEffusion;
  QCollapsableWidget*                            CWPericardialEffusion;

  QSubstanceBolusWidget*                         SubstanceBolus;
  QCollapsableWidget*                            CWSubstanceBolus;

  QSubstanceCompoundInfusionWidget*              SubstanceCompoundInfusion;
  QCollapsableWidget*                            CWSubstanceCompoundInfusion;

  QSubstanceInfusionWidget*                      SubstanceInfusion;
  QCollapsableWidget*                            CWSubstanceInfusion;

  QSupplementalOxygenWidget*                     SupplementalOxygen;
  QCollapsableWidget*                            CWSupplementalOxygen;

  QTensionPneumothoraxWidget*                    TensionPneumothorax;
  QCollapsableWidget*                            CWTensionPneumothorax;

};

QActionsEditorWidget::QActionsEditorWidget(QPulse& qp, QWidget *parent, Qt::WindowFlags flags) : QDockWidget(parent,flags)
{
  m_Controls = new Controls(qp);
  m_Controls->setupUi(this);

  m_Controls->CWAcuteStress = new QCollapsableWidget("AcuteStress", 120, this);
  m_Controls->AcuteStress = new QAcuteStressWidget(qp, this);
  m_Controls->CWAcuteStress->setVisible(true);
  m_Controls->CWAcuteStress->layout()->addWidget(m_Controls->AcuteStress);
  m_Controls->CWAcuteStress->setContentLayout(*m_Controls->AcuteStress->layout());
  m_Controls->ActionWidgets->layout()->addWidget(m_Controls->CWAcuteStress);

  m_Controls->CWAirwayObstruction = new QCollapsableWidget("AirwayObstruction", 120, this);
  m_Controls->AirwayObstruction = new QAirwayObstructionWidget(qp, this);
  m_Controls->CWAirwayObstruction->setVisible(true);
  m_Controls->CWAirwayObstruction->layout()->addWidget(m_Controls->AirwayObstruction);
  m_Controls->CWAirwayObstruction->setContentLayout(*m_Controls->AirwayObstruction->layout());
  m_Controls->ActionWidgets->layout()->addWidget(m_Controls->CWAirwayObstruction);

  m_Controls->CWApnea = new QCollapsableWidget("Apnea", 120, this);
  m_Controls->Apnea = new QApneaWidget(qp, this);
  m_Controls->CWApnea->setVisible(true);
  m_Controls->CWApnea->layout()->addWidget(m_Controls->Apnea);
  m_Controls->CWApnea->setContentLayout(*m_Controls->Apnea->layout());
  m_Controls->ActionWidgets->layout()->addWidget(m_Controls->CWApnea);

  m_Controls->CWAsthmaAttack = new QCollapsableWidget("AsthmaAttack", 120, this);
  m_Controls->AsthmaAttack = new QAsthmaAttackWidget(qp, this);
  m_Controls->CWAsthmaAttack->setVisible(true);
  m_Controls->CWAsthmaAttack->layout()->addWidget(m_Controls->AsthmaAttack);
  m_Controls->CWAsthmaAttack->setContentLayout(*m_Controls->AsthmaAttack->layout());
  m_Controls->ActionWidgets->layout()->addWidget(m_Controls->CWAsthmaAttack);

  m_Controls->CWBronchoconstriction = new QCollapsableWidget("Bronchoconstriction", 120, this);
  m_Controls->Bronchoconstriction = new QBronchoconstrictionWidget(qp, this);
  m_Controls->CWBronchoconstriction->setVisible(true);
  m_Controls->CWBronchoconstriction->layout()->addWidget(m_Controls->Bronchoconstriction);
  m_Controls->CWBronchoconstriction->setContentLayout(*m_Controls->Bronchoconstriction->layout());
  m_Controls->ActionWidgets->layout()->addWidget(m_Controls->CWBronchoconstriction);

  m_Controls->CWCardiacArrest = new QCollapsableWidget("CardiacArrest", 120, this);
  m_Controls->CardiacArrest = new QCardiacArrestWidget(qp, this);
  m_Controls->CWCardiacArrest->setVisible(true);
  m_Controls->CWCardiacArrest->layout()->addWidget(m_Controls->CardiacArrest);
  m_Controls->CWCardiacArrest->setContentLayout(*m_Controls->CardiacArrest->layout());
  m_Controls->ActionWidgets->layout()->addWidget(m_Controls->CWCardiacArrest);

  m_Controls->CWChestCompressionForceScale = new QCollapsableWidget("ChestCompressionForceScale", 120, this);
  m_Controls->ChestCompressionForceScale = new QChestCompressionForceScaleWidget(qp, this);
  m_Controls->CWChestCompressionForceScale->setVisible(true);
  m_Controls->CWChestCompressionForceScale->layout()->addWidget(m_Controls->ChestCompressionForceScale);
  m_Controls->CWChestCompressionForceScale->setContentLayout(*m_Controls->ChestCompressionForceScale->layout());
  m_Controls->ActionWidgets->layout()->addWidget(m_Controls->CWChestCompressionForceScale);

  m_Controls->CWChestOcclusiveDressing = new QCollapsableWidget("ChestOcclusiveDressing", 120, this);
  m_Controls->ChestOcclusiveDressing = new QChestOcclusiveDressingWidget(qp, this);
  m_Controls->CWChestOcclusiveDressing->setVisible(true);
  m_Controls->CWChestOcclusiveDressing->layout()->addWidget(m_Controls->ChestOcclusiveDressing);
  m_Controls->CWChestOcclusiveDressing->setContentLayout(*m_Controls->ChestOcclusiveDressing->layout());
  m_Controls->ActionWidgets->layout()->addWidget(m_Controls->CWChestOcclusiveDressing);

  //m_Controls->CWConsciousRespiration = new QCollapsableWidget("ConsciousRespiration", 120, this);
  //m_Controls->ConsciousRespiration = new QConsciousRespirationWidget(qp, this);
  //m_Controls->CWConsciousRespiration->setVisible(true);
  //m_Controls->CWConsciousRespiration->layout()->addWidget(m_Controls->ConsciousRespiration);
  //m_Controls->CWConsciousRespiration->setContentLayout(*m_Controls->ConsciousRespiration->layout());
  //m_Controls->ActionWidgets->layout()->addWidget(m_Controls->CWConsciousRespiration);

  m_Controls->CWExercise = new QCollapsableWidget("Exercise", 120, this);
  m_Controls->Exercise = new QExerciseWidget(qp, this);
  m_Controls->CWExercise->setVisible(true);
  m_Controls->CWExercise->layout()->addWidget(m_Controls->Exercise);
  m_Controls->CWExercise->setContentLayout(*m_Controls->Exercise->layout());
  m_Controls->ActionWidgets->layout()->addWidget(m_Controls->CWExercise);

  m_Controls->CWHemorrhage = new QCollapsableWidget("Hemorrhage", 120, this);
  m_Controls->Hemorrhage = new QHemorrhageWidget(qp, this);
  m_Controls->CWHemorrhage->setVisible(true);
  m_Controls->CWHemorrhage->layout()->addWidget(m_Controls->Hemorrhage);
  m_Controls->CWHemorrhage->setContentLayout(*m_Controls->Hemorrhage->layout());
  m_Controls->ActionWidgets->layout()->addWidget(m_Controls->CWHemorrhage);

  m_Controls->CWIntubation = new QCollapsableWidget("Intubation", 120, this);
  m_Controls->Intubation = new QIntubationWidget(qp, this);
  m_Controls->CWIntubation->setVisible(true);
  m_Controls->CWIntubation->layout()->addWidget(m_Controls->Intubation);
  m_Controls->CWIntubation->setContentLayout(*m_Controls->Intubation->layout());
  m_Controls->ActionWidgets->layout()->addWidget(m_Controls->CWIntubation);

  m_Controls->CWNeedleDecompression = new QCollapsableWidget("NeedleDecompression", 120, this);
  m_Controls->NeedleDecompression = new QNeedleDecompressionWidget(qp, this);
  m_Controls->CWNeedleDecompression->setVisible(true);
  m_Controls->CWNeedleDecompression->layout()->addWidget(m_Controls->NeedleDecompression);
  m_Controls->CWNeedleDecompression->setContentLayout(*m_Controls->NeedleDecompression->layout());
  m_Controls->ActionWidgets->layout()->addWidget(m_Controls->CWNeedleDecompression);

  m_Controls->CWPericardialEffusion = new QCollapsableWidget("PericardialEffusion", 120, this);
  m_Controls->PericardialEffusion = new QPericardialEffusionWidget(qp, this);
  m_Controls->CWPericardialEffusion->setVisible(true);
  m_Controls->CWPericardialEffusion->layout()->addWidget(m_Controls->PericardialEffusion);
  m_Controls->CWPericardialEffusion->setContentLayout(*m_Controls->PericardialEffusion->layout());
  m_Controls->ActionWidgets->layout()->addWidget(m_Controls->CWPericardialEffusion);

  m_Controls->CWSubstanceBolus = new QCollapsableWidget("SubstanceBolus", 120, this);
  m_Controls->SubstanceBolus = new QSubstanceBolusWidget(qp, this);
  m_Controls->CWSubstanceBolus->setVisible(true);
  m_Controls->CWSubstanceBolus->layout()->addWidget(m_Controls->SubstanceBolus);
  m_Controls->CWSubstanceBolus->setContentLayout(*m_Controls->SubstanceBolus->layout());
  m_Controls->ActionWidgets->layout()->addWidget(m_Controls->CWSubstanceBolus);

  m_Controls->CWSubstanceCompoundInfusion = new QCollapsableWidget("SubstanceCompoundInfusion", 120, this);
  m_Controls->SubstanceCompoundInfusion = new QSubstanceCompoundInfusionWidget(qp, this);
  m_Controls->CWSubstanceCompoundInfusion->setVisible(true);
  m_Controls->CWSubstanceCompoundInfusion->layout()->addWidget(m_Controls->SubstanceCompoundInfusion);
  m_Controls->CWSubstanceCompoundInfusion->setContentLayout(*m_Controls->SubstanceCompoundInfusion->layout());
  m_Controls->ActionWidgets->layout()->addWidget(m_Controls->CWSubstanceCompoundInfusion);

  m_Controls->CWSubstanceInfusion = new QCollapsableWidget("SubstanceInfusion", 120, this);
  m_Controls->SubstanceInfusion = new QSubstanceInfusionWidget(qp, this);
  m_Controls->CWSubstanceInfusion->setVisible(true);
  m_Controls->CWSubstanceInfusion->layout()->addWidget(m_Controls->SubstanceInfusion);
  m_Controls->CWSubstanceInfusion->setContentLayout(*m_Controls->SubstanceInfusion->layout());
  m_Controls->ActionWidgets->layout()->addWidget(m_Controls->CWSubstanceInfusion);

  m_Controls->CWSupplementalOxygen = new QCollapsableWidget("SupplementalOxygen", 120, this);
  m_Controls->SupplementalOxygen = new QSupplementalOxygenWidget(qp, this);
  m_Controls->CWSupplementalOxygen->setVisible(true);
  m_Controls->CWSupplementalOxygen->layout()->addWidget(m_Controls->SupplementalOxygen);
  m_Controls->CWSupplementalOxygen->setContentLayout(*m_Controls->SupplementalOxygen->layout());
  m_Controls->ActionWidgets->layout()->addWidget(m_Controls->CWSupplementalOxygen);

  m_Controls->CWTensionPneumothorax = new QCollapsableWidget("TensionPneumothorax", 120, this);
  m_Controls->TensionPneumothorax = new QTensionPneumothoraxWidget(qp, this);
  m_Controls->CWTensionPneumothorax->setVisible(true);
  m_Controls->CWTensionPneumothorax->layout()->addWidget(m_Controls->TensionPneumothorax);
  m_Controls->CWTensionPneumothorax->setContentLayout(*m_Controls->TensionPneumothorax->layout());
  m_Controls->ActionWidgets->layout()->addWidget(m_Controls->CWTensionPneumothorax);

  QSpacerItem *spacer = new QSpacerItem(40, 1000, QSizePolicy::Expanding, QSizePolicy::Expanding);
  m_Controls->ActionWidgets->layout()->addItem(spacer);
}

QActionsEditorWidget::~QActionsEditorWidget()
{
  delete m_Controls;
}

void QActionsEditorWidget::Reset()
{
  m_Controls->AcuteStress->Reset();
  m_Controls->AirwayObstruction->Reset();
  m_Controls->Apnea->Reset();
  m_Controls->AsthmaAttack->Reset();
  m_Controls->Bronchoconstriction->Reset();
  m_Controls->CardiacArrest->Reset();
  m_Controls->ChestCompressionForceScale->Reset();
  m_Controls->ChestOcclusiveDressing->Reset();
  //m_Controls->ConsciousRespiration->reset();
  m_Controls->Exercise->Reset();
  m_Controls->Hemorrhage->Reset();
  m_Controls->Intubation->Reset();
  m_Controls->NeedleDecompression->Reset();
  m_Controls->PericardialEffusion->Reset();
  m_Controls->SubstanceBolus->Reset();
  m_Controls->SubstanceCompoundInfusion->Reset();
  m_Controls->SubstanceInfusion->Reset();
  m_Controls->SupplementalOxygen->Reset();
  m_Controls->TensionPneumothorax->Reset();

  m_Controls->CWAcuteStress->expand(false);
  m_Controls->CWAirwayObstruction->expand(false);
  m_Controls->CWApnea->expand(false);
  m_Controls->CWAsthmaAttack->expand(false);
  m_Controls->CWBronchoconstriction->expand(false);
  m_Controls->CWCardiacArrest->expand(false);
  m_Controls->CWChestCompressionForceScale->expand(false);
  m_Controls->CWChestOcclusiveDressing->expand(false);
  //m_Controls->CWConsciousRespiration->expand(false);
  m_Controls->CWExercise->expand(false);
  m_Controls->CWHemorrhage->expand(false);
  m_Controls->CWIntubation->expand(false);
  m_Controls->CWNeedleDecompression->expand(false);
  m_Controls->CWPericardialEffusion->expand(false);
  m_Controls->CWSubstanceBolus->expand(false);
  m_Controls->CWSubstanceCompoundInfusion->expand(false);
  m_Controls->CWSubstanceInfusion->expand(false);
  m_Controls->CWSupplementalOxygen->expand(false);
  m_Controls->CWTensionPneumothorax->expand(false);

  EnableInput(true);
}

void QActionsEditorWidget::EnableInput(bool b)
{
  m_Controls->AcuteStress->SetEnabled(b);
  m_Controls->AirwayObstruction->SetEnabled(b);
  m_Controls->Apnea->SetEnabled(b);
  m_Controls->AsthmaAttack->SetEnabled(b);
  m_Controls->Bronchoconstriction->SetEnabled(b);
  m_Controls->CardiacArrest->SetEnabled(b);
  m_Controls->ChestCompressionForceScale->SetEnabled(b);
  m_Controls->ChestOcclusiveDressing->SetEnabled(b);
  //m_Controls->ConsciousRespiration->SetEnabled(b);
  m_Controls->Exercise->SetEnabled(b);
  m_Controls->Hemorrhage->SetEnabled(b);
  m_Controls->Intubation->SetEnabled(b);
  m_Controls->NeedleDecompression->SetEnabled(b);
  m_Controls->PericardialEffusion->SetEnabled(b);
  m_Controls->SubstanceBolus->SetEnabled(b);
  m_Controls->SubstanceCompoundInfusion->SetEnabled(b);
  m_Controls->SubstanceInfusion->SetEnabled(b);
  m_Controls->SupplementalOxygen->SetEnabled(b);
  m_Controls->TensionPneumothorax->SetEnabled(b);
}

void QActionsEditorWidget::AtSteadyState(PhysiologyEngine& pulse)
{
  m_Controls->AcuteStress->AtSteadyState(pulse);
  m_Controls->AirwayObstruction->AtSteadyState(pulse);
  m_Controls->Apnea->AtSteadyState(pulse);
  m_Controls->AsthmaAttack->AtSteadyState(pulse);
  m_Controls->Bronchoconstriction->AtSteadyState(pulse);
  m_Controls->CardiacArrest->AtSteadyState(pulse);
  m_Controls->ChestCompressionForceScale->AtSteadyState(pulse);
  m_Controls->ChestOcclusiveDressing->AtSteadyState(pulse);
  //m_Controls->ConsciousRespiration->AtSteadyState(pulse);
  m_Controls->Exercise->AtSteadyState(pulse);
  m_Controls->Hemorrhage->AtSteadyState(pulse);
  m_Controls->Intubation->AtSteadyState(pulse);
  m_Controls->NeedleDecompression->AtSteadyState(pulse);
  m_Controls->PericardialEffusion->AtSteadyState(pulse);
  m_Controls->SubstanceBolus->AtSteadyState(pulse);
  m_Controls->SubstanceCompoundInfusion->AtSteadyState(pulse);
  m_Controls->SubstanceInfusion->AtSteadyState(pulse);
  m_Controls->SupplementalOxygen->AtSteadyState(pulse);
  m_Controls->TensionPneumothorax->AtSteadyState(pulse);
}
void QActionsEditorWidget::AtSteadyStateUpdateUI()
{
  m_Controls->AcuteStress->AtSteadyStateUpdateUI();
  m_Controls->AirwayObstruction->AtSteadyStateUpdateUI();
  m_Controls->Apnea->AtSteadyStateUpdateUI();
  m_Controls->AsthmaAttack->AtSteadyStateUpdateUI();
  m_Controls->Bronchoconstriction->AtSteadyStateUpdateUI();
  m_Controls->CardiacArrest->AtSteadyStateUpdateUI();
  m_Controls->ChestCompressionForceScale->AtSteadyStateUpdateUI();
  m_Controls->ChestOcclusiveDressing->AtSteadyStateUpdateUI();
  //m_Controls->ConsciousRespiration->AtSteadyStateUpdateUI();
  m_Controls->Exercise->AtSteadyStateUpdateUI();
  m_Controls->Hemorrhage->AtSteadyStateUpdateUI();
  m_Controls->Intubation->AtSteadyStateUpdateUI();
  m_Controls->NeedleDecompression->AtSteadyStateUpdateUI();
  m_Controls->PericardialEffusion->AtSteadyStateUpdateUI();
  m_Controls->SubstanceBolus->AtSteadyStateUpdateUI();
  m_Controls->SubstanceCompoundInfusion->AtSteadyStateUpdateUI();
  m_Controls->SubstanceInfusion->AtSteadyStateUpdateUI();
  m_Controls->SupplementalOxygen->AtSteadyStateUpdateUI();
  m_Controls->TensionPneumothorax->AtSteadyStateUpdateUI();
}

void QActionsEditorWidget::ProcessPhysiology(PhysiologyEngine& pulse)
{
  m_Controls->AcuteStress->ProcessPhysiology(pulse);
  m_Controls->AirwayObstruction->ProcessPhysiology(pulse);
  m_Controls->Apnea->ProcessPhysiology(pulse);
  m_Controls->AsthmaAttack->ProcessPhysiology(pulse);
  m_Controls->Bronchoconstriction->ProcessPhysiology(pulse);
  m_Controls->CardiacArrest->ProcessPhysiology(pulse);
  m_Controls->ChestCompressionForceScale->ProcessPhysiology(pulse);
  m_Controls->ChestOcclusiveDressing->ProcessPhysiology(pulse);
  //m_Controls->ConsciousRespiration->ProcessPhysiology(pulse);
  m_Controls->Exercise->ProcessPhysiology(pulse);
  m_Controls->Hemorrhage->ProcessPhysiology(pulse);
  m_Controls->Intubation->ProcessPhysiology(pulse);
  m_Controls->NeedleDecompression->ProcessPhysiology(pulse);
  m_Controls->PericardialEffusion->ProcessPhysiology(pulse);
  m_Controls->SubstanceBolus->ProcessPhysiology(pulse);
  m_Controls->SubstanceCompoundInfusion->ProcessPhysiology(pulse);
  m_Controls->SubstanceInfusion->ProcessPhysiology(pulse);
  m_Controls->SupplementalOxygen->ProcessPhysiology(pulse);
  m_Controls->TensionPneumothorax->ProcessPhysiology(pulse);
}
void QActionsEditorWidget::PhysiologyUpdateUI()
{
  m_Controls->AcuteStress->PhysiologyUpdateUI();
  m_Controls->AirwayObstruction->PhysiologyUpdateUI();
  m_Controls->Apnea->PhysiologyUpdateUI();
  m_Controls->AsthmaAttack->PhysiologyUpdateUI();
  m_Controls->Bronchoconstriction->PhysiologyUpdateUI();
  m_Controls->CardiacArrest->PhysiologyUpdateUI();
  m_Controls->ChestCompressionForceScale->PhysiologyUpdateUI();
  m_Controls->ChestOcclusiveDressing->PhysiologyUpdateUI();
  //m_Controls->ConsciousRespiration->PhysiologyUpdateUI();
  m_Controls->Exercise->PhysiologyUpdateUI();
  m_Controls->Hemorrhage->PhysiologyUpdateUI();
  m_Controls->Intubation->PhysiologyUpdateUI();
  m_Controls->NeedleDecompression->PhysiologyUpdateUI();
  m_Controls->PericardialEffusion->PhysiologyUpdateUI();
  m_Controls->SubstanceBolus->PhysiologyUpdateUI();
  m_Controls->SubstanceCompoundInfusion->PhysiologyUpdateUI();
  m_Controls->SubstanceInfusion->PhysiologyUpdateUI();
  m_Controls->SupplementalOxygen->PhysiologyUpdateUI();
  m_Controls->TensionPneumothorax->PhysiologyUpdateUI();
}

