/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#pragma once

#include <QObject>
#include <QWidget>
class SECondition;

namespace Ui {
  class ConditionWidget;
}

class QConditionWidget : public QWidget
{
  Q_OBJECT
public:
  QConditionWidget(QWidget *parent = Q_NULLPTR, Qt::WindowFlags flags = Qt::WindowFlags());
  virtual ~QConditionWidget();

  virtual void reset();
  virtual bool isSelected();
  virtual void setEnabled(bool b);// Turn on/off check box
  virtual void enableCondition(bool b);// Sets Check to on/off
  virtual void enableConverter(bool b) = 0;

  virtual const SECondition& getCondition()=0;
  virtual void setCondition(const SECondition& c)=0;

protected slots:
virtual void enableConditionInput(bool b);// Tells condition properties to be all on/off

virtual void enableProperties(bool b) = 0;// Turn on/off properties

private:
  class Controls;
  Controls* m_Controls;
};