/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#include "ChronicPericardialEffusionWidget.h"
#include "controls/ScalarQuantityWidget.h"

#include "cdm/CommonDataModel.h"
#include "cdm/patient/conditions/SEChronicPericardialEffusion.h"
#include "cdm/properties/SEScalarVolume.h"

class QChronicPericardialEffusionWidget::Controls
{
public:
  Controls() {}
  ~Controls()
  {
    //delete AccumulatedVolume;
  }
  QScalarQuantityWidget<VolumeUnit>* AccumulatedVolume;
  SEChronicPericardialEffusion Condition;
};

QChronicPericardialEffusionWidget::QChronicPericardialEffusionWidget(QWidget *parent, Qt::WindowFlags flags) : QConditionWidget(parent,flags)
{
  m_Controls = new Controls();
  m_Controls->AccumulatedVolume = new QScalarQuantityWidget<VolumeUnit>("Accumulated Volume", 0, 1000, 1, VolumeUnit::mL, ScalarOptionWidget::None, this);
  m_Controls->AccumulatedVolume->addUnit(VolumeUnit::L);
  layout()->addWidget(m_Controls->AccumulatedVolume);
  reset();

}

QChronicPericardialEffusionWidget::~QChronicPericardialEffusionWidget()
{
  delete m_Controls;
}


void QChronicPericardialEffusionWidget::reset()
{
  QConditionWidget::reset();
  m_Controls->Condition.Clear();
  m_Controls->AccumulatedVolume->reset();
  enableProperties(false);
}

void QChronicPericardialEffusionWidget::enableProperties(bool b)
{
  m_Controls->AccumulatedVolume->enableInput(b);
  m_Controls->AccumulatedVolume->enableConverter(!b);
}
void QChronicPericardialEffusionWidget::enableConverter(bool b)
{
  m_Controls->AccumulatedVolume->enableConverter(b);
}

const SECondition& QChronicPericardialEffusionWidget::getCondition()
{
  m_Controls->Condition.Clear();
  m_Controls->AccumulatedVolume->getValue(m_Controls->Condition.GetAccumulatedVolume());
  return m_Controls->Condition;
}

void QChronicPericardialEffusionWidget::setCondition(const SECondition& c)
{
  m_Controls->Condition.Copy((SEChronicPericardialEffusion&)(c));
  m_Controls->AccumulatedVolume->setValue(m_Controls->Condition.GetAccumulatedVolume());
  QConditionWidget::enableCondition(c.IsActive());
}

