/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#include "actions/PericardialEffusionWidget.h"
#include "controls/ScalarQuantityWidget.h"

#include "cdm/CommonDataModel.h"
#include "PhysiologyEngine.h"
#include "cdm/patient/actions/SEPericardialEffusion.h"
#include "cdm/properties/SEScalarVolumePerTime.h"

class QPericardialEffusionWidget::Controls // based off of chronic anemia widget
{
public:
  Controls() {}
  SEPericardialEffusion Action;
  QScalarQuantityWidget<VolumePerTimeUnit>* EffusionRate; // check this
};

QPericardialEffusionWidget::QPericardialEffusionWidget(QPulse& qp, QWidget *parent, Qt::WindowFlags flags) : QActionWidget(qp, parent, flags)
{
  m_Controls = new Controls();
  m_Controls->EffusionRate = new QScalarQuantityWidget<VolumePerTimeUnit>("Effusion Rate", 0, 1000, 0.1, VolumePerTimeUnit::mL_Per_min, ScalarOptionWidget::None, this);
  m_Controls->EffusionRate->addUnit(VolumePerTimeUnit::mL_Per_min);
  m_Controls->EffusionRate->addUnit(VolumePerTimeUnit::L_Per_s);
  m_Controls->EffusionRate->addUnit(VolumePerTimeUnit::L_Per_min);
  Properties()->layout()->addWidget(m_Controls->EffusionRate);
  Reset();
}

QPericardialEffusionWidget::~QPericardialEffusionWidget()
{
  delete m_Controls;
}

void QPericardialEffusionWidget::Reset()
{
  QActionWidget::Reset();
  m_Controls->Action.Clear();
  m_Controls->EffusionRate->reset();
}

void QPericardialEffusionWidget::SetEnabled(bool b)
{
  QActionWidget::SetEnabled(b);
  m_Controls->EffusionRate->enableInput(b);
  m_Controls->EffusionRate->setEnabled(b);
}

void QPericardialEffusionWidget::ControlsToAction()
{
  QActionWidget::ControlsToAction();
  m_Controls->EffusionRate->getValue(m_Controls->Action.GetEffusionRate());
}

void QPericardialEffusionWidget::AtSteadyState(PhysiologyEngine& pulse)
{
  // Nothing expected here
}
void QPericardialEffusionWidget::AtSteadyStateUpdateUI()
{
  // Nothing expected here
}

void QPericardialEffusionWidget::ProcessPhysiology(PhysiologyEngine& pulse)
{// This is called from a thread, you should NOT update UI here
  // This is where we pull data from pulse, and push any actions to it
  if (m_PassAction)
  {
    if (m_Controls->Action.IsValid())
      pulse.ProcessAction(m_Controls->Action);
    m_PassAction = false;
  }
}
void QPericardialEffusionWidget::PhysiologyUpdateUI()
{// This is called from a slot, you can update UI here

  // Nothing is expected to be in the environment
}