/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#include "actions/IntubationWidget.h"
#include "controls/ScalarWidget.h"

#include "cdm/CommonDataModel.h"
#include "PhysiologyEngine.h"
#include "cdm/patient/actions/SEIntubation.h"
#include <QString>
#include <vector>
#include "controls/LabeledComboBox.h"

class QIntubationWidget::Controls // based off of chronic anemia widget
{
public:
  Controls() {}
  SEIntubation Action;
  QLabeledComboBox*   Type;
};

QIntubationWidget::QIntubationWidget(QPulse& qp, QWidget *parent, Qt::WindowFlags flags) : QActionWidget(qp, parent, flags)
{
  m_Controls = new Controls();
  std::vector<QString> typeOptions = { "Off", "Esophageal", "LeftMainstem", "RightMainstem", "Tracheal"};
  m_Controls->Type = new QLabeledComboBox(this, "Type", typeOptions, 85);
  Properties()->layout()->addWidget(m_Controls->Type);
  Reset();
}

QIntubationWidget::~QIntubationWidget()
{
  delete m_Controls;
}

void QIntubationWidget::Reset()
{
  QActionWidget::Reset();
  m_Controls->Action.Clear();
}

void QIntubationWidget::SetEnabled(bool b)
{
  QActionWidget::SetEnabled(b);
  m_Controls->Type->SetEnabled(b);
}

void QIntubationWidget::ControlsToAction()
{
  QActionWidget::ControlsToAction();
  m_Controls->Action.SetType((eIntubation_Type)m_Controls->Type->GetIndex());
}

void QIntubationWidget::AtSteadyState(PhysiologyEngine& pulse)
{
  // Nothing expected here
}
void QIntubationWidget::AtSteadyStateUpdateUI()
{
  // Nothing expected here
}

void QIntubationWidget::ProcessPhysiology(PhysiologyEngine& pulse)
{// This is called from a thread, you should NOT update UI here
  // This is where we pull data from pulse, and push any actions to it
  if (m_PassAction)
  {
    if (m_Controls->Action.IsValid())
      pulse.ProcessAction(m_Controls->Action);
    m_PassAction = false;
  }
}
void QIntubationWidget::PhysiologyUpdateUI()
{// This is called from a slot, you can update UI here

  // Nothing is expected to be in the environment
}