/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#include "actions/ExerciseWidget.h"
#include "controls/ScalarWidget.h"

#include "cdm/CommonDataModel.h"
#include "PhysiologyEngine.h"
#include "cdm/patient/actions/SEExercise.h"
#include "cdm/properties/SEScalar0To1.h"

class QExerciseWidget::Controls // based off of chronic anemia widget
{
public:
  Controls() {}
  SEExercise Action;
  QScalarWidget* Intensity; // check this
};

QExerciseWidget::QExerciseWidget(QPulse& qp, QWidget *parent, Qt::WindowFlags flags) : QActionWidget(qp, parent, flags)
{
  m_Controls = new Controls();
  m_Controls->Intensity = new QScalarWidget("Intensity", 0, 1, 0.01, ScalarOptionWidget::None, this); //check this
  Properties()->layout()->addWidget(m_Controls->Intensity);
  Reset();
}

QExerciseWidget::~QExerciseWidget()
{
  delete m_Controls;
}

void QExerciseWidget::Reset()
{
  QActionWidget::Reset();
  m_Controls->Action.Clear();
  m_Controls->Intensity->reset();
}

void QExerciseWidget::SetEnabled(bool b)
{
  QActionWidget::SetEnabled(b);
  m_Controls->Intensity->enableInput(b);
}

void QExerciseWidget::ControlsToAction()
{
  QActionWidget::ControlsToAction();
  m_Controls->Intensity->getValue(m_Controls->Action.GetIntensity());
}

void QExerciseWidget::AtSteadyState(PhysiologyEngine& pulse)
{
  // Nothing expected here
}
void QExerciseWidget::AtSteadyStateUpdateUI()
{
  // Nothing expected here
}

void QExerciseWidget::ProcessPhysiology(PhysiologyEngine& pulse)
{// This is called from a thread, you should NOT update UI here
  // This is where we pull data from pulse, and push any actions to it
  if (m_PassAction)
  {
    if (m_Controls->Action.IsValid())
      pulse.ProcessAction(m_Controls->Action);
    m_PassAction = false;
  }
}
void QExerciseWidget::PhysiologyUpdateUI()
{// This is called from a slot, you can update UI here

  // Nothing is expected to be in the environment
}