/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#pragma once

#include <QObject>
#include <QWidget>
#include "actions/ActionWidget.h"

class QCardiacArrestWidget : public QActionWidget, public PulseListener
{
  Q_OBJECT
public:
  QCardiacArrestWidget(QPulse& qp, QWidget *parent = Q_NULLPTR, Qt::WindowFlags flags = Qt::WindowFlags());
  virtual ~QCardiacArrestWidget();

  virtual void Reset() override;
  virtual void SetEnabled(bool b) override;

  virtual void AtSteadyState(PhysiologyEngine& pulse) override;
  virtual void AtSteadyStateUpdateUI() override;// Main Window will call this to update UI Components
  virtual void ProcessPhysiology(PhysiologyEngine& pulse) override;
  virtual void PhysiologyUpdateUI() override;// Main Window will call this to update UI Components

  virtual void ControlsToAction() override;
  
private:
  class Controls;
  Controls* m_Controls;
  
};