/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#pragma once

#include <QObject>
#include <QWidget>
#include "controls/QPulse.h"

class SEAction;

namespace Ui {
  class ActionWidget;
}

class QActionWidget : public QWidget
{
  Q_OBJECT
public:
  QActionWidget(QPulse& qp, QWidget *parent = Q_NULLPTR, Qt::WindowFlags flags = Qt::WindowFlags());
  virtual ~QActionWidget();

  virtual void Reset();
  virtual void SetEnabled(bool b);
  virtual QWidget* Properties();
  
protected:
  bool m_PassAction = false;
  virtual void ControlsToAction();

protected slots:
  void ApplyAction() { ControlsToAction(); }

private:
  class Controls;
  Controls* m_Controls;
};