/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#include "controls/conditions/AcuteRespiratoryDistressSyndromeWidget.h"
#include "controls/ScalarWidget.h"

#include "pulse/cdm/CommonDefs.h"
#include "pulse/cdm/patient/conditions/SEAcuteRespiratoryDistressSyndrome.h"
#include "pulse/cdm/properties/SEScalar0To1.h"

class QAcuteRespiratoryDistressSyndromeWidget::Controls
{
public:
  Controls() {}
  SEAcuteRespiratoryDistressSyndrome Condition;
  QScalarWidget* Severity;
  QScalarWidget* LeftLungAffected;
  QScalarWidget* RightLungAffected;
};

QAcuteRespiratoryDistressSyndromeWidget::QAcuteRespiratoryDistressSyndromeWidget(QWidget *parent, Qt::WindowFlags flags) : QConditionWidget(parent,flags)
{
  m_Controls = new Controls();
  m_Controls->Severity = new QScalarWidget("Severity", 0, 1, 0.1, ScalarOptionWidget::None, this);
  layout()->addWidget(m_Controls->Severity);
  m_Controls->LeftLungAffected = new QScalarWidget("Left Lung Affected", 0, 1, 0.1, ScalarOptionWidget::None, this);
  layout()->addWidget(m_Controls->LeftLungAffected);
  m_Controls->RightLungAffected = new QScalarWidget("Right Lung Affected", 0, 1, 0.1, ScalarOptionWidget::None, this);
  layout()->addWidget(m_Controls->RightLungAffected);
  Reset();
}

QAcuteRespiratoryDistressSyndromeWidget::~QAcuteRespiratoryDistressSyndromeWidget()
{
  delete m_Controls;
}

void QAcuteRespiratoryDistressSyndromeWidget::Reset()
{
  QConditionWidget::Reset();
  m_Controls->Condition.Clear();
  m_Controls->Severity->Reset();
  m_Controls->LeftLungAffected->Reset();
  m_Controls->RightLungAffected->Reset();
  EnableProperties(false);
}

void QAcuteRespiratoryDistressSyndromeWidget::EnableProperties(bool b)
{
  m_Controls->Severity->EnableInput(b);
  m_Controls->LeftLungAffected->EnableInput(b);
  m_Controls->RightLungAffected->EnableInput(b);
}
void QAcuteRespiratoryDistressSyndromeWidget::EnableConverter(bool b)
{
}

const SECondition& QAcuteRespiratoryDistressSyndromeWidget::GetCondition()
{
  m_Controls->Condition.Clear();
  m_Controls->Severity->GetValue(m_Controls->Condition.GetSeverity());
  m_Controls->LeftLungAffected->GetValue(m_Controls->Condition.GetLeftLungAffected());
  m_Controls->RightLungAffected->GetValue(m_Controls->Condition.GetRightLungAffected());
  return m_Controls->Condition;
}

void QAcuteRespiratoryDistressSyndromeWidget::SetCondition(const SECondition& c)
{
  m_Controls->Condition.Copy(static_cast<const SEAcuteRespiratoryDistressSyndrome&>(c));
  m_Controls->Severity->SetValue(m_Controls->Condition.GetSeverity());
  m_Controls->LeftLungAffected->SetValue(m_Controls->Condition.GetLeftLungAffected());
  m_Controls->RightLungAffected->SetValue(m_Controls->Condition.GetRightLungAffected());
  QConditionWidget::EnableCondition(c.IsActive());
}

