/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#include "controls/actions/ChronicObstructivePulmonaryDiseaseExacerbationWidget.h"
#include "controls/ScalarWidget.h"
#include "controls/ScalarQuantityWidget.h"

#include "pulse/cdm/CommonDefs.h"
#include "pulse/cdm/PhysiologyEngine.h"
#include "pulse/cdm/properties/SEScalar0To1.h"

class QChronicObstructivePulmonaryDiseaseExacerbationWidget::Controls
{
public:
  Controls(QPulse& qp) : Pulse(qp) {}
  QPulse&                                          Pulse;
  SEChronicObstructivePulmonaryDiseaseExacerbation Action;
  QScalarWidget*                                   BronchitisSeverity;
  QScalarWidget*                                   EmphysemaSeverity;
};

QChronicObstructivePulmonaryDiseaseExacerbationWidget::QChronicObstructivePulmonaryDiseaseExacerbationWidget(QPulse& qp, QWidget *parent, Qt::WindowFlags flags) : QActionWidget(qp, parent, flags)
{
  m_Controls = new Controls(qp);
  m_Controls->BronchitisSeverity = new QScalarWidget("Bronchitis Severity", 0, 1, 0.1, ScalarOptionWidget::None, this);
  Properties()->layout()->addWidget(m_Controls->BronchitisSeverity);
  m_Controls->EmphysemaSeverity = new QScalarWidget("Emphysema Severity", 0, 1, 0.1, ScalarOptionWidget::None, this);
  Properties()->layout()->addWidget(m_Controls->EmphysemaSeverity);
  Properties()->layout()->addWidget(GetProcessTimeCtrl());
  Reset();
}

QChronicObstructivePulmonaryDiseaseExacerbationWidget::~QChronicObstructivePulmonaryDiseaseExacerbationWidget()
{
  delete m_Controls;
}

void QChronicObstructivePulmonaryDiseaseExacerbationWidget::Reset()
{
  QActionWidget::Reset();
  m_Controls->Action.Clear();
  m_Controls->BronchitisSeverity->Reset();
  m_Controls->EmphysemaSeverity->Reset();
}

SEAction& QChronicObstructivePulmonaryDiseaseExacerbationWidget::GetAction()
{
  return m_Controls->Action;
}
const SEAction& QChronicObstructivePulmonaryDiseaseExacerbationWidget::GetAction() const
{
  return m_Controls->Action;
}

void QChronicObstructivePulmonaryDiseaseExacerbationWidget::SetEnabled(bool b)
{
  QActionWidget::SetEnabled(b);
  m_Controls->BronchitisSeverity->EnableInput(b);
  m_Controls->EmphysemaSeverity->EnableInput(b);
}

void QChronicObstructivePulmonaryDiseaseExacerbationWidget::ControlsToAction()
{
  QActionWidget::ControlsToAction();
  m_Controls->BronchitisSeverity->GetValue(m_Controls->Action.GetBronchitisSeverity());
  m_Controls->EmphysemaSeverity->GetValue(m_Controls->Action.GetEmphysemaSeverity());
  emit UpdateAction(m_Controls->Action, GetProcessTime());
}

void QChronicObstructivePulmonaryDiseaseExacerbationWidget::ActionToControls(const SEChronicObstructivePulmonaryDiseaseExacerbation& action)
{
  QActionWidget::ActionToControls(action);
  SEScalar data;
  data.SetValue(action.GetBronchitisSeverity());
  m_Controls->BronchitisSeverity->SetValue(data);
  data.SetValue(action.GetEmphysemaSeverity());
  m_Controls->EmphysemaSeverity->SetValue(data);
}
