/* Distributed under the Apache License, Version 2.0.
   See accompanying NOTICE file for details.*/
#pragma once

#include <QWidget>
#include "QPulse.h"

namespace Ui {
class VentilatorWidget;
}

class LabeledDialWidget;

class QVentilatorWidget : public QWidget, public PulseListener
{
  Q_OBJECT
public:
  QVentilatorWidget(QWidget *parent = Q_NULLPTR, Qt::WindowFlags flags = Qt::WindowFlags());
  virtual ~QVentilatorWidget();

  void Reset();

  void AtSteadyState(PhysiologyEngine& pulse) override;
  void ProcessPhysiology(PhysiologyEngine& pulse) override;
  void AtSteadyStateUpdateUI() override;
  void PhysiologyUpdateUI(const std::vector<SEAction const*>& actions) override;
  void EngineErrorUI() override;

  void StartEngine();


signals:
  void UpdateAction(SEAction const&, SEScalarTime const&);

protected slots:
  /// Used to update the slope widget with a new range
  void updateSlope(double value);

  /// On apply take the current mode and input parameters and
  /// apply an action to pulse
  void applyAction();

  /// Disconnect the ventilator
  void disconnectAction();

  ///@{
  /// Handle holds
  void addHold();
  void removeHold();
  ///@}

  void setMode(QString val);
  void resetDials();

protected:
  ///@{
  /// The range of the slope is dependent on another widgets range, set up and connect
  /// the two
  void setupSlope(LabeledDialWidget* tiWidget, LabeledDialWidget* slopeWidget);
  void clearSlope();
  ///@}

  /// Display a number of dials
  /// \param maxIndex the index of the last dial to show, dials with index higher
  ///        will be hidden in the UI
  void showDials(int maxIndex);

  void setupNumbers();

  ///@{
  /// When hold is clicked, the UI should be locked for input
  void lockForHold();
  void unlock();

private:
  struct Private;
  Private* d;
};
