/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#include "controls/actions/LobarPneumoniaExacerbationWidget.h"
#include "controls/LabeledComboBox.h"
#include "controls/ScalarWidget.h"

#include "pulse/CommonDataModel.h"
#include "pulse/PhysiologyEngine.h"
#include "pulse/properties/SEScalar0To1.h"

class QLobarPneumoniaExacerbationWidget::Controls // based off of chronic anemia widget
{
public:
  Controls(QPulse& qp) : Pulse(qp) {}
  QPulse&                      Pulse;
  SELobarPneumoniaExacerbation Action;
  QScalarWidget*               Severity;
  QScalarWidget*               LeftLungAffected;
  QScalarWidget*               RightLungAffected;
};

QLobarPneumoniaExacerbationWidget::QLobarPneumoniaExacerbationWidget(QPulse& qp, QWidget *parent, Qt::WindowFlags flags) : QActionWidget(qp, parent, flags)
{
  m_Controls = new Controls(qp);
  m_Controls->Severity = new QScalarWidget("Severity", 0, 1, 0.1, ScalarOptionWidget::None, this);
  m_Controls->LeftLungAffected = new QScalarWidget("Left Lung Affected", 0, 1, 0.1, ScalarOptionWidget::None, this);
  m_Controls->RightLungAffected = new QScalarWidget("Right LungA ffected", 0, 1, 0.1, ScalarOptionWidget::None, this);
  Properties()->layout()->addWidget(m_Controls->Severity);
  Properties()->layout()->addWidget(m_Controls->LeftLungAffected);
  Properties()->layout()->addWidget(m_Controls->RightLungAffected);
  Properties()->layout()->addWidget(GetProcessTimeCtrl());
  Reset();
}

QLobarPneumoniaExacerbationWidget::~QLobarPneumoniaExacerbationWidget()
{
  delete m_Controls;
}

void QLobarPneumoniaExacerbationWidget::Reset()
{
  QActionWidget::Reset();
  m_Controls->Action.Clear();
}

SEAction& QLobarPneumoniaExacerbationWidget::GetAction()
{
  return m_Controls->Action;
}
const SEAction& QLobarPneumoniaExacerbationWidget::GetAction() const
{
  return m_Controls->Action;
}

void QLobarPneumoniaExacerbationWidget::SetEnabled(bool b)
{
  QActionWidget::SetEnabled(b);
  m_Controls->Severity->EnableInput(b);
  m_Controls->Severity->setEnabled(b);
  m_Controls->LeftLungAffected->EnableInput(b);
  m_Controls->LeftLungAffected->setEnabled(b);
  m_Controls->RightLungAffected->EnableInput(b);
  m_Controls->RightLungAffected->setEnabled(b);
}

void QLobarPneumoniaExacerbationWidget::ControlsToAction()
{
  QActionWidget::ControlsToAction();
  m_Controls->Severity->GetValue(m_Controls->Action.GetSeverity());
  m_Controls->LeftLungAffected->GetValue(m_Controls->Action.GetLeftLungAffected());
  m_Controls->RightLungAffected->GetValue(m_Controls->Action.GetRightLungAffected());
  emit UpateAction(m_Controls->Action, GetProcessTime());
}

void QLobarPneumoniaExacerbationWidget::ActionToControls(const SELobarPneumoniaExacerbation& action)
{
  QActionWidget::ActionToControls(action);
  SEScalar data;
  data.SetValue(action.GetSeverity());
  m_Controls->Severity->SetValue(data);

  data.SetValue(action.GetLeftLungAffected());
  m_Controls->LeftLungAffected->SetValue(data);

  data.SetValue(action.GetRightLungAffected());
  m_Controls->RightLungAffected->SetValue(data);
}
