/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#include "controls/actions/IntubationWidget.h"
#include "controls/LabeledComboBox.h"
#include "controls/ScalarWidget.h"

#include "pulse/CommonDataModel.h"
#include "pulse/PhysiologyEngine.h"

class QIntubationWidget::Controls // based off of chronic anemia widget
{
public:
  Controls(QPulse& qp) : Pulse(qp) {}
  QPulse&             Pulse;
  SEIntubation        Action;
  QLabeledComboBox*   Type;
};

QIntubationWidget::QIntubationWidget(QPulse& qp, QWidget *parent, Qt::WindowFlags flags) : QActionWidget(qp, parent, flags)
{
  m_Controls = new Controls(qp);
  std::vector<QString> typeOptions = { "Off", "Esophageal", "LeftMainstem", "RightMainstem", "Tracheal"};
  m_Controls->Type = new QLabeledComboBox(this, "Type", typeOptions, 85);
  Properties()->layout()->addWidget(m_Controls->Type);
  Properties()->layout()->addWidget(GetProcessTimeCtrl());
  Reset();
}

QIntubationWidget::~QIntubationWidget()
{
  delete m_Controls;
}

void QIntubationWidget::Reset()
{
  QActionWidget::Reset();
  m_Controls->Action.Clear();
}

SEAction& QIntubationWidget::GetAction()
{
  return m_Controls->Action;
}
const SEAction& QIntubationWidget::GetAction() const
{
  return m_Controls->Action;
}

void QIntubationWidget::SetEnabled(bool b)
{
  QActionWidget::SetEnabled(b);
  m_Controls->Type->SetEnabled(b);
}

void QIntubationWidget::ControlsToAction()
{
  QActionWidget::ControlsToAction();
  m_Controls->Action.SetType((eIntubation_Type)m_Controls->Type->GetIndex());
  emit UpateAction(m_Controls->Action, GetProcessTime());
}

void QIntubationWidget::ActionToControls(const SEIntubation& action)
{
  QActionWidget::ActionToControls(action);
  QComboBox* typeBox = m_Controls->Type->GetComboBox();
  switch (action.GetType())
  {
  case eIntubation_Type::Esophageal:
    typeBox->setCurrentIndex(typeBox->findText("Esophageal"));
    break;
  case eIntubation_Type::LeftMainstem:
    typeBox->setCurrentIndex(typeBox->findText("LeftMainstem"));
    break;
  case eIntubation_Type::RightMainstem:
    typeBox->setCurrentIndex(typeBox->findText("RightMainstem"));
    break;
  case eIntubation_Type::Tracheal:
    typeBox->setCurrentIndex(typeBox->findText("Tracheal"));
    break;
  default:
    typeBox->setCurrentIndex(typeBox->findText("Off"));
    break;
  }
}
