/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#include "controls/actions/AcuteStressWidget.h"
#include "controls/ScalarWidget.h"
#include "controls/ScalarQuantityWidget.h"

#include "pulse/CommonDataModel.h"
#include "pulse/PhysiologyEngine.h"
#include "pulse/properties/SEScalar0To1.h"

class QAcuteStressWidget::Controls
{
public:
  Controls(QPulse& qp) : Pulse(qp) {}
  QPulse&                          Pulse;
  SEAcuteStress                    Action;
  QScalarWidget*                   Severity;
};

QAcuteStressWidget::QAcuteStressWidget(QPulse& qp, QWidget *parent, Qt::WindowFlags flags) : QActionWidget(qp, parent, flags)
{
  m_Controls = new Controls(qp);
  m_Controls->Severity = new QScalarWidget("Severity", 0, 1, 0.1, ScalarOptionWidget::None , this);

  Properties()->layout()->addWidget(m_Controls->Severity);
  Properties()->layout()->addWidget(GetProcessTimeCtrl());
  Reset();
}

QAcuteStressWidget::~QAcuteStressWidget()
{
  delete m_Controls;
}

void QAcuteStressWidget::Reset()
{
  QActionWidget::Reset();
  m_Controls->Action.Clear();
  m_Controls->Severity->Reset();
}

SEAction& QAcuteStressWidget::GetAction()
{
  return m_Controls->Action;
}
const SEAction& QAcuteStressWidget::GetAction() const
{
  return m_Controls->Action;
}

void QAcuteStressWidget::SetEnabled(bool b)
{
  QActionWidget::SetEnabled(b);
  m_Controls->Severity->EnableInput(b);
}

void QAcuteStressWidget::ControlsToAction()
{
  QActionWidget::ControlsToAction();
  m_Controls->Severity->GetValue(m_Controls->Action.GetSeverity());
  emit UpateAction(m_Controls->Action, GetProcessTime());
}

void QAcuteStressWidget::ActionToControls(const SEAcuteStress& action)
{
  QActionWidget::ActionToControls(action);
  SEScalar data;
  data.SetValue(action.GetSeverity());
  m_Controls->Severity->SetValue(data);
}
