/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#include "controls/actions/AcuteRespiratoryDistressSyndromeExacerbationWidget.h"
#include "controls/ScalarWidget.h"
#include "controls/ScalarQuantityWidget.h"

#include "pulse/CommonDataModel.h"
#include "pulse/PhysiologyEngine.h"
#include "pulse/properties/SEScalar0To1.h"

class QAcuteRespiratoryDistressSyndromeExacerbationWidget::Controls
{
public:
  Controls(QPulse& qp) : Pulse(qp) {}
  QPulse&             Pulse;
  SEAcuteRespiratoryDistressSyndromeExacerbation Action;
  QScalarWidget*      Severity;
  QScalarWidget*      LeftLungAffected;
  QScalarWidget*      RightLungAffected;
};

QAcuteRespiratoryDistressSyndromeExacerbationWidget::QAcuteRespiratoryDistressSyndromeExacerbationWidget(QPulse& qp, QWidget *parent, Qt::WindowFlags flags) : QActionWidget(qp, parent, flags)
{
  m_Controls = new Controls(qp);
  m_Controls->Severity = new QScalarWidget("Severity", 0, 1, 0.1, ScalarOptionWidget::None, this);
  Properties()->layout()->addWidget(m_Controls->Severity);
  m_Controls->LeftLungAffected = new QScalarWidget("Left Lung Affected", 0, 1, 0.1, ScalarOptionWidget::None, this);
  layout()->addWidget(m_Controls->LeftLungAffected);
  m_Controls->RightLungAffected = new QScalarWidget("Right Lung Affected", 0, 1, 0.1, ScalarOptionWidget::None, this);
  layout()->addWidget(m_Controls->RightLungAffected);
  Properties()->layout()->addWidget(GetProcessTimeCtrl());
  Reset();
}

QAcuteRespiratoryDistressSyndromeExacerbationWidget::~QAcuteRespiratoryDistressSyndromeExacerbationWidget()
{
  delete m_Controls;
}

void QAcuteRespiratoryDistressSyndromeExacerbationWidget::Reset()
{
  QActionWidget::Reset();
  m_Controls->Action.Clear();
  m_Controls->Severity->Reset();
  m_Controls->LeftLungAffected->Reset();
  m_Controls->RightLungAffected->Reset();
}

SEAction& QAcuteRespiratoryDistressSyndromeExacerbationWidget::GetAction()
{
  return m_Controls->Action;
}
const SEAction& QAcuteRespiratoryDistressSyndromeExacerbationWidget::GetAction() const
{
  return m_Controls->Action;
}

void QAcuteRespiratoryDistressSyndromeExacerbationWidget::SetEnabled(bool b)
{
  QActionWidget::SetEnabled(b);
  m_Controls->Severity->EnableInput(b);
  m_Controls->LeftLungAffected->EnableInput(b);
  m_Controls->RightLungAffected->EnableInput(b);
}

void QAcuteRespiratoryDistressSyndromeExacerbationWidget::ControlsToAction()
{
  QActionWidget::ControlsToAction();
  m_Controls->Severity->GetValue(m_Controls->Action.GetSeverity());
  m_Controls->LeftLungAffected->GetValue(m_Controls->Action.GetLeftLungAffected());
  m_Controls->RightLungAffected->GetValue(m_Controls->Action.GetRightLungAffected());
  emit UpateAction(m_Controls->Action, GetProcessTime());
}

void QAcuteRespiratoryDistressSyndromeExacerbationWidget::ActionToControls(const SEAcuteRespiratoryDistressSyndromeExacerbation& action)
{
  QActionWidget::ActionToControls(action);
  SEScalar data;
  data.SetValue(action.GetSeverity());
  m_Controls->Severity->SetValue(data);
  data.SetValue(action.GetLeftLungAffected());
  m_Controls->LeftLungAffected->SetValue(data);
  data.SetValue(action.GetRightLungAffected());
  m_Controls->RightLungAffected->SetValue(data);
}
