/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#pragma once

#include <QWidget>

#include <memory>

class PulsePainterPlot : public QWidget
{
  Q_OBJECT

public:
  PulsePainterPlot(QWidget* parent = nullptr);
  virtual ~PulsePainterPlot();

  void setMaxPoints(int count);
  void setDataRange(double min, double max);
  void setPadding(double amount = 0.05);

public slots:
  void append(double time, double value);
  void clear();

protected:
  void paintEvent(QPaintEvent*) override;

private:
  class Private;
  std::unique_ptr<Private> d;
};
