/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#pragma once

#include <QObject>
#include <QDockWidget>
#include "QPulse.h"

class SEEnvironmentalConditions;

namespace Ui {
  class EnviornmentWidget;
}

class QEnviornmentWidget : public QDockWidget, public PulseListener
{
  Q_OBJECT
public:
  QEnviornmentWidget(QPulse& qp, QWidget *parent = Q_NULLPTR, Qt::WindowFlags flags = Qt::WindowFlags());
  virtual ~QEnviornmentWidget();

  void Reset();
  //SECondition& GetInitialEnvironmentConditions();

  void EnableControls(bool conditions, bool actions);

  void AtSteadyState(PhysiologyEngine& pulse) override;
  void AtSteadyStateUpdateUI() override;// Main Window will call this to update UI Components
  void ProcessPhysiology(PhysiologyEngine& pulse) override;
  void PhysiologyUpdateUI() override;// Main Window will call this to update UI Components
  void EngineErrorUI() override {};// Main Window will call this to update UI Components

//signals:
protected slots:
  void EnableCooling();
  void EnableCoolingSurfaceArea();
  void EnableCoolingSurfaceAreaFraction();
  void EnableHeating();
  void EnableHeatingSurfaceArea();
  void EnableHeatingSurfaceAreaFraction();
  void EnableAppliedTemp();
  void EnableAppliedTempSurfaceArea();
  void EnableAppliedSurfaceAreaFraction();
  void LoadEnvironmentFile();
  void LoadEnvironmentFile(const std::string& fileName);
  void SaveEnvironmentFile();
  void SaveEnviornmentFile(const std::string& fileName);
  

  void ControlsToEnvironment();
  void EnvironmentToControls();

private:
  class Controls;
  Controls* m_Controls;
};