/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#include "ActionsEditorWidget.h"
#include "ui_ActionsEditor.h"
#include <QMessageBox>
#include <QLabel>

#include "CollapsableWidget.h"

#include "actions/ActionWidget.h"
#include "actions/AcuteRespiratoryDistressSyndromeExacerbationWidget.h"
#include "actions/AcuteStressWidget.h"
#include "actions/AirwayObstructionWidget.h"
#include "actions/AsthmaAttackWidget.h"
#include "actions/BrainInjuryWidget.h"
#include "actions/BronchoconstrictionWidget.h"
#include "actions/CardiacArrestWidget.h"
#include "actions/ChestCompressionForceScaleWidget.h"
#include "actions/ChestOcclusiveDressingWidget.h"
#include "actions/ChronicObstructivePulmonaryDiseaseExacerbationWidget.h"
//#include "actions/ConsciousRespirationWidget.h"
#include "actions/DyspneaWidget.h"
#include "actions/ExerciseWidget.h"
#include "actions/HemorrhageWidget.h"
#include "actions/ImpairedAlveolarExchangeExacerbationWidget.h"
#include "actions/IntubationWidget.h"
#include "actions/LobarPneumoniaExacerbationWidget.h"
#include "actions/NeedleDecompressionWidget.h"
#include "actions/PericardialEffusionWidget.h"
#include "actions/PulmonaryShuntExacerbationWidget.h"
#include "actions/RespiratoryFatigueWidget.h"
#include "actions/SerializeStateWidget.h"
#include "actions/SubstanceBolusWidget.h"
#include "actions/SubstanceCompoundInfusionWidget.h"
#include "actions/SubstanceInfusionWidget.h"
#include "actions/SupplementalOxygenWidget.h"
#include "actions/TensionPneumothoraxWidget.h"
#include "actions/UrinateWidget.h"

#include "pulse/CommonDataModel.h"
#include "pulse/engine/SEPatientConfiguration.h"
#include "pulse/engine/SEActionManager.h"
#include "pulse/engine/SEAction.h"
// All the actions for checking against later.
#include "pulse/engine/SESerializeState.h"
#include "pulse/patient/actions/SEAcuteRespiratoryDistressSyndromeExacerbation.h"
#include "pulse/patient/actions/SEAcuteStress.h"
#include "pulse/patient/actions/SEAirwayObstruction.h"
#include "pulse/patient/actions/SEAsthmaAttack.h"
#include "pulse/patient/actions/SEBrainInjury.h"
#include "pulse/patient/actions/SEBronchoconstriction.h"
#include "pulse/patient/actions/SECardiacArrest.h"
#include "pulse/patient/actions/SEChestCompressionForceScale.h"
#include "pulse/patient/actions/SEChestOcclusiveDressing.h"
#include "pulse/patient/actions/SEChronicObstructivePulmonaryDiseaseExacerbation.h"
#include "pulse/patient/actions/SEDyspnea.h"
#include "pulse/patient/actions/SEExercise.h"
#include "pulse/patient/actions/SEHemorrhage.h"
#include "pulse/patient/actions/SEImpairedAlveolarExchangeExacerbation.h"
#include "pulse/patient/actions/SEIntubation.h"
#include "pulse/patient/actions/SELobarPneumoniaExacerbation.h"
#include "pulse/patient/actions/SENeedleDecompression.h"
#include "pulse/patient/actions/SEPericardialEffusion.h"
#include "pulse/patient/actions/SEPulmonaryShuntExacerbation.h"
#include "pulse/patient/actions/SERespiratoryFatigue.h"
#include "pulse/patient/actions/SESubstanceBolus.h"
#include "pulse/patient/actions/SESubstanceCompoundInfusion.h"
#include "pulse/patient/actions/SESubstanceInfusion.h"
#include "pulse/patient/actions/SESupplementalOxygen.h"
#include "pulse/patient/actions/SETensionPneumothorax.h"
#include "pulse/patient/actions/SEUrinate.h"


class QActionsEditorWidget::Controls : public Ui::ActionsEditorWidget
{
public:
  Controls(QPulse& qp) : Pulse(qp) {}
  QPulse&                Pulse;
  
  QAcuteRespiratoryDistressSyndromeExacerbationWidget*   AcuteRespiratoryDistressSyndromeExacerbation;
  QCollapsableWidget*                                    CWAcuteRespiratoryDistressSyndromeExacerbation;

  QAcuteStressWidget*                                    AcuteStress;
  QCollapsableWidget*                                    CWAcuteStress;

  QAirwayObstructionWidget*                              AirwayObstruction;
  QCollapsableWidget*                                    CWAirwayObstruction;

  QAsthmaAttackWidget*                                   AsthmaAttack;
  QCollapsableWidget*                                    CWAsthmaAttack;

  QBrainInjuryWidget*                                    BrainInjury;
  QCollapsableWidget*                                    CWBrainInjury;

  QBronchoconstrictionWidget*                            Bronchoconstriction;
  QCollapsableWidget*                                    CWBronchoconstriction;

  QCardiacArrestWidget*                                  CardiacArrest;
  QCollapsableWidget*                                    CWCardiacArrest;

  QChestCompressionForceScaleWidget*                     ChestCompressionForceScale;
  QCollapsableWidget*                                    CWChestCompressionForceScale;

  QChestOcclusiveDressingWidget*                         ChestOcclusiveDressing;
  QCollapsableWidget*                                    CWChestOcclusiveDressing;

  QChronicObstructivePulmonaryDiseaseExacerbationWidget* ChronicObstructivePulmonaryDiseaseExacerbation;
  QCollapsableWidget*                                    CWChronicObstructivePulmonaryDiseaseExacerbation;

  //QConsciousRespirationWidget*                         ConsciousRespiration;
  //QCollapsableWidget*                                  CWConsciousRespiration;

  QDyspneaWidget*                                        Dyspnea;
  QCollapsableWidget*                                    CWDyspnea;

  QExerciseWidget*                                       Exercise;
  QCollapsableWidget*                                    CWExercise;

  QHemorrhageWidget*                                     Hemorrhage;
  QCollapsableWidget*                                    CWHemorrhage;

  QImpairedAlveolarExchangeExacerbationWidget*           ImpairedAlveolarExchangeExacerbation;
  QCollapsableWidget*                                    CWImpairedAlveolarExchangeExacerbation;

  QIntubationWidget*                                     Intubation;
  QCollapsableWidget*                                    CWIntubation;

  QLobarPneumoniaExacerbationWidget*                     LobarPneumoniaExacerbation;
  QCollapsableWidget*                                    CWLobarPneumoniaExacerbation;

  QNeedleDecompressionWidget*                            NeedleDecompression;
  QCollapsableWidget*                                    CWNeedleDecompression;

  QPericardialEffusionWidget*                            PericardialEffusion;
  QCollapsableWidget*                                    CWPericardialEffusion;

  QPulmonaryShuntExacerbationWidget*                     PulmonaryShuntExacerbation;
  QCollapsableWidget*                                    CWPulmonaryShuntExacerbation;

  QRespiratoryFatigueWidget*                             RespiratoryFatigue;
  QCollapsableWidget*                                    CWRespiratoryFatigue;

  QSerializeStateWidget*                                 SerializeState;
  QCollapsableWidget*                                    CWSerializeState;

  QSubstanceBolusWidget*                                 SubstanceBolus;
  QCollapsableWidget*                                    CWSubstanceBolus;

  QSubstanceCompoundInfusionWidget*                      SubstanceCompoundInfusion;
  QCollapsableWidget*                                    CWSubstanceCompoundInfusion;

  QSubstanceInfusionWidget*                              SubstanceInfusion;
  QCollapsableWidget*                                    CWSubstanceInfusion;

  QSupplementalOxygenWidget*                             SupplementalOxygen;
  QCollapsableWidget*                                    CWSupplementalOxygen;

  QTensionPneumothoraxWidget*                            TensionPneumothorax;
  QCollapsableWidget*                                    CWTensionPneumothorax;

  QUrinateWidget*                                        Urinate;
  QCollapsableWidget*                                    CWUrinate;

};

QActionsEditorWidget::QActionsEditorWidget(QPulse& qp, QWidget *parent, Qt::WindowFlags flags) : QDockWidget(parent,flags)
{
  m_Controls = new Controls(qp);
  m_Controls->setupUi(this);

  m_Controls->CWAcuteRespiratoryDistressSyndromeExacerbation = new QCollapsableWidget("ARDS Exacerbation", 120, this);
  m_Controls->AcuteRespiratoryDistressSyndromeExacerbation = new QAcuteRespiratoryDistressSyndromeExacerbationWidget(qp, this);
  m_Controls->CWAcuteRespiratoryDistressSyndromeExacerbation->setVisible(true);
  m_Controls->CWAcuteRespiratoryDistressSyndromeExacerbation->layout()->addWidget(m_Controls->AcuteRespiratoryDistressSyndromeExacerbation);
  m_Controls->CWAcuteRespiratoryDistressSyndromeExacerbation->setContentLayout(*m_Controls->AcuteRespiratoryDistressSyndromeExacerbation->layout());
  m_Controls->ActionWidgets->layout()->addWidget(m_Controls->CWAcuteRespiratoryDistressSyndromeExacerbation);
  connect(m_Controls->AcuteRespiratoryDistressSyndromeExacerbation, SIGNAL(UpateAction(SEAction const&, SEScalarTime const&)), SIGNAL(UpateAction(SEAction const&, SEScalarTime const&)));

  m_Controls->CWAcuteStress = new QCollapsableWidget("Acute Stress", 120, this);
  m_Controls->AcuteStress = new QAcuteStressWidget(qp, this);
  m_Controls->CWAcuteStress->setVisible(true);
  m_Controls->CWAcuteStress->layout()->addWidget(m_Controls->AcuteStress);
  m_Controls->CWAcuteStress->setContentLayout(*m_Controls->AcuteStress->layout());
  m_Controls->ActionWidgets->layout()->addWidget(m_Controls->CWAcuteStress);
  connect(m_Controls->AcuteStress, SIGNAL(UpateAction(SEAction const&,SEScalarTime const&)), SIGNAL(UpateAction(SEAction const&,SEScalarTime const&)));

  m_Controls->CWAirwayObstruction = new QCollapsableWidget("Airway Obstruction", 120, this);
  m_Controls->AirwayObstruction = new QAirwayObstructionWidget(qp, this);
  m_Controls->CWAirwayObstruction->setVisible(true);
  m_Controls->CWAirwayObstruction->layout()->addWidget(m_Controls->AirwayObstruction);
  m_Controls->CWAirwayObstruction->setContentLayout(*m_Controls->AirwayObstruction->layout());
  m_Controls->ActionWidgets->layout()->addWidget(m_Controls->CWAirwayObstruction);
  connect(m_Controls->AirwayObstruction, SIGNAL(UpateAction(SEAction const&,SEScalarTime const&)), SIGNAL(UpateAction(SEAction const&,SEScalarTime const&)));

  m_Controls->CWAsthmaAttack = new QCollapsableWidget("Asthma Attack", 120, this);
  m_Controls->AsthmaAttack = new QAsthmaAttackWidget(qp, this);
  m_Controls->CWAsthmaAttack->setVisible(true);
  m_Controls->CWAsthmaAttack->layout()->addWidget(m_Controls->AsthmaAttack);
  m_Controls->CWAsthmaAttack->setContentLayout(*m_Controls->AsthmaAttack->layout());
  m_Controls->ActionWidgets->layout()->addWidget(m_Controls->CWAsthmaAttack);
  connect(m_Controls->AsthmaAttack, SIGNAL(UpateAction(SEAction const&,SEScalarTime const&)), SIGNAL(UpateAction(SEAction const&,SEScalarTime const&)));

  m_Controls->CWBrainInjury = new QCollapsableWidget("Brain Injury", 120, this);
  m_Controls->BrainInjury = new QBrainInjuryWidget(qp, this);
  m_Controls->CWBrainInjury->setVisible(true);
  m_Controls->CWBrainInjury->layout()->addWidget(m_Controls->BrainInjury);
  m_Controls->CWBrainInjury->setContentLayout(*m_Controls->BrainInjury->layout());
  m_Controls->ActionWidgets->layout()->addWidget(m_Controls->CWBrainInjury);
  connect(m_Controls->BrainInjury, SIGNAL(UpateAction(SEAction const&, SEScalarTime const&)), SIGNAL(UpateAction(SEAction const&, SEScalarTime const&)));

  m_Controls->CWBronchoconstriction = new QCollapsableWidget("Bronchoconstriction", 120, this);
  m_Controls->Bronchoconstriction = new QBronchoconstrictionWidget(qp, this);
  m_Controls->CWBronchoconstriction->setVisible(true);
  m_Controls->CWBronchoconstriction->layout()->addWidget(m_Controls->Bronchoconstriction);
  m_Controls->CWBronchoconstriction->setContentLayout(*m_Controls->Bronchoconstriction->layout());
  m_Controls->ActionWidgets->layout()->addWidget(m_Controls->CWBronchoconstriction);
  connect(m_Controls->Bronchoconstriction, SIGNAL(UpateAction(SEAction const&,SEScalarTime const&)), SIGNAL(UpateAction(SEAction const&,SEScalarTime const&)));

  m_Controls->CWCardiacArrest = new QCollapsableWidget("Cardiac Arrest", 120, this);
  m_Controls->CardiacArrest = new QCardiacArrestWidget(qp, this);
  m_Controls->CWCardiacArrest->setVisible(true);
  m_Controls->CWCardiacArrest->layout()->addWidget(m_Controls->CardiacArrest);
  m_Controls->CWCardiacArrest->setContentLayout(*m_Controls->CardiacArrest->layout());
  m_Controls->ActionWidgets->layout()->addWidget(m_Controls->CWCardiacArrest);
  connect(m_Controls->CardiacArrest, SIGNAL(UpateAction(SEAction const&,SEScalarTime const&)), SIGNAL(UpateAction(SEAction const&,SEScalarTime const&)));

  m_Controls->CWChestCompressionForceScale = new QCollapsableWidget("Chest Compression Force Scale", 120, this);
  m_Controls->ChestCompressionForceScale = new QChestCompressionForceScaleWidget(qp, this);
  m_Controls->CWChestCompressionForceScale->setVisible(true);
  m_Controls->CWChestCompressionForceScale->layout()->addWidget(m_Controls->ChestCompressionForceScale);
  m_Controls->CWChestCompressionForceScale->setContentLayout(*m_Controls->ChestCompressionForceScale->layout());
  m_Controls->ActionWidgets->layout()->addWidget(m_Controls->CWChestCompressionForceScale);
  connect(m_Controls->ChestCompressionForceScale, SIGNAL(UpateAction(SEAction const&,SEScalarTime const&)), SIGNAL(UpateAction(SEAction const&,SEScalarTime const&)));

  m_Controls->CWChestOcclusiveDressing = new QCollapsableWidget("Chest Occlusive Dressing", 120, this);
  m_Controls->ChestOcclusiveDressing = new QChestOcclusiveDressingWidget(qp, this);
  m_Controls->CWChestOcclusiveDressing->setVisible(true);
  m_Controls->CWChestOcclusiveDressing->layout()->addWidget(m_Controls->ChestOcclusiveDressing);
  m_Controls->CWChestOcclusiveDressing->setContentLayout(*m_Controls->ChestOcclusiveDressing->layout());
  m_Controls->ActionWidgets->layout()->addWidget(m_Controls->CWChestOcclusiveDressing);
  connect(m_Controls->ChestOcclusiveDressing, SIGNAL(UpateAction(SEAction const&,SEScalarTime const&)), SIGNAL(UpateAction(SEAction const&,SEScalarTime const&)));

  m_Controls->CWChronicObstructivePulmonaryDiseaseExacerbation = new QCollapsableWidget("COPD Exacerbation", 120, this);
  m_Controls->ChronicObstructivePulmonaryDiseaseExacerbation = new QChronicObstructivePulmonaryDiseaseExacerbationWidget(qp, this);
  m_Controls->CWChronicObstructivePulmonaryDiseaseExacerbation->setVisible(true);
  m_Controls->CWChronicObstructivePulmonaryDiseaseExacerbation->layout()->addWidget(m_Controls->ChronicObstructivePulmonaryDiseaseExacerbation);
  m_Controls->CWChronicObstructivePulmonaryDiseaseExacerbation->setContentLayout(*m_Controls->ChronicObstructivePulmonaryDiseaseExacerbation->layout());
  m_Controls->ActionWidgets->layout()->addWidget(m_Controls->CWChronicObstructivePulmonaryDiseaseExacerbation);
  connect(m_Controls->ChronicObstructivePulmonaryDiseaseExacerbation, SIGNAL(UpateAction(SEAction const&, SEScalarTime const&)), SIGNAL(UpateAction(SEAction const&, SEScalarTime const&)));

  //m_Controls->CWConsciousRespiration = new QCollapsableWidget("Conscious Respiration", 120, this);
  //m_Controls->ConsciousRespiration = new QConsciousRespirationWidget(qp, this);
  //m_Controls->CWConsciousRespiration->setVisible(true);
  //m_Controls->CWConsciousRespiration->layout()->addWidget(m_Controls->ConsciousRespiration);
  //m_Controls->CWConsciousRespiration->setContentLayout(*m_Controls->ConsciousRespiration->layout());
  //m_Controls->ActionWidgets->layout()->addWidget(m_Controls->CWConsciousRespiration);

  m_Controls->CWDyspnea = new QCollapsableWidget("Dyspnea", 120, this);
  m_Controls->Dyspnea = new QDyspneaWidget(qp, this);
  m_Controls->CWDyspnea->setVisible(true);
  m_Controls->CWDyspnea->layout()->addWidget(m_Controls->Dyspnea);
  m_Controls->CWDyspnea->setContentLayout(*m_Controls->Dyspnea->layout());
  m_Controls->ActionWidgets->layout()->addWidget(m_Controls->CWDyspnea);
  connect(m_Controls->Dyspnea, SIGNAL(UpateAction(SEAction const&,SEScalarTime const&)), SIGNAL(UpateAction(SEAction const&,SEScalarTime const&)));

  m_Controls->CWExercise = new QCollapsableWidget("Exercise", 120, this);
  m_Controls->Exercise = new QExerciseWidget(qp, this);
  m_Controls->CWExercise->setVisible(true);
  m_Controls->CWExercise->layout()->addWidget(m_Controls->Exercise);
  m_Controls->CWExercise->setContentLayout(*m_Controls->Exercise->layout());
  m_Controls->ActionWidgets->layout()->addWidget(m_Controls->CWExercise);
  connect(m_Controls->Exercise, SIGNAL(UpateAction(SEAction const&,SEScalarTime const&)), SIGNAL(UpateAction(SEAction const&,SEScalarTime const&)));

  m_Controls->CWHemorrhage = new QCollapsableWidget("Hemorrhage", 120, this);
  m_Controls->Hemorrhage = new QHemorrhageWidget(qp, this);
  m_Controls->CWHemorrhage->setVisible(true);
  m_Controls->CWHemorrhage->layout()->addWidget(m_Controls->Hemorrhage);
  m_Controls->CWHemorrhage->setContentLayout(*m_Controls->Hemorrhage->layout());
  m_Controls->ActionWidgets->layout()->addWidget(m_Controls->CWHemorrhage);
  connect(m_Controls->Hemorrhage, SIGNAL(UpateAction(SEAction const&,SEScalarTime const&)), SIGNAL(UpateAction(SEAction const&,SEScalarTime const&)));

  m_Controls->CWImpairedAlveolarExchangeExacerbation = new QCollapsableWidget("Impaired Alveolar Exchange Exacerbation", 120, this);
  m_Controls->ImpairedAlveolarExchangeExacerbation = new QImpairedAlveolarExchangeExacerbationWidget(qp, this);
  m_Controls->CWImpairedAlveolarExchangeExacerbation->setVisible(true);
  m_Controls->CWImpairedAlveolarExchangeExacerbation->layout()->addWidget(m_Controls->ImpairedAlveolarExchangeExacerbation);
  m_Controls->CWImpairedAlveolarExchangeExacerbation->setContentLayout(*m_Controls->ImpairedAlveolarExchangeExacerbation->layout());
  m_Controls->ActionWidgets->layout()->addWidget(m_Controls->CWImpairedAlveolarExchangeExacerbation);
  connect(m_Controls->ImpairedAlveolarExchangeExacerbation, SIGNAL(UpateAction(SEAction const&, SEScalarTime const&)), SIGNAL(UpateAction(SEAction const&, SEScalarTime const&)));

  m_Controls->CWIntubation = new QCollapsableWidget("Intubation", 120, this);
  m_Controls->Intubation = new QIntubationWidget(qp, this);
  m_Controls->CWIntubation->setVisible(true);
  m_Controls->CWIntubation->layout()->addWidget(m_Controls->Intubation);
  m_Controls->CWIntubation->setContentLayout(*m_Controls->Intubation->layout());
  m_Controls->ActionWidgets->layout()->addWidget(m_Controls->CWIntubation);
  connect(m_Controls->Intubation, SIGNAL(UpateAction(SEAction const&,SEScalarTime const&)), SIGNAL(UpateAction(SEAction const&,SEScalarTime const&)));

  m_Controls->CWLobarPneumoniaExacerbation = new QCollapsableWidget("Lobar Pneumonia Exacerbation", 120, this);
  m_Controls->LobarPneumoniaExacerbation = new QLobarPneumoniaExacerbationWidget(qp, this);
  m_Controls->CWLobarPneumoniaExacerbation->setVisible(true);
  m_Controls->CWLobarPneumoniaExacerbation->layout()->addWidget(m_Controls->LobarPneumoniaExacerbation);
  m_Controls->CWLobarPneumoniaExacerbation->setContentLayout(*m_Controls->LobarPneumoniaExacerbation->layout());
  m_Controls->ActionWidgets->layout()->addWidget(m_Controls->CWLobarPneumoniaExacerbation);
  connect(m_Controls->LobarPneumoniaExacerbation, SIGNAL(UpateAction(SEAction const&, SEScalarTime const&)), SIGNAL(UpateAction(SEAction const&, SEScalarTime const&)));

  m_Controls->CWNeedleDecompression = new QCollapsableWidget("Needle Decompression", 120, this);
  m_Controls->NeedleDecompression = new QNeedleDecompressionWidget(qp, this);
  m_Controls->CWNeedleDecompression->setVisible(true);
  m_Controls->CWNeedleDecompression->layout()->addWidget(m_Controls->NeedleDecompression);
  m_Controls->CWNeedleDecompression->setContentLayout(*m_Controls->NeedleDecompression->layout());
  m_Controls->ActionWidgets->layout()->addWidget(m_Controls->CWNeedleDecompression);
  connect(m_Controls->NeedleDecompression, SIGNAL(UpateAction(SEAction const&, SEScalarTime const&)), SIGNAL(UpateAction(SEAction const&, SEScalarTime const&)));

  m_Controls->CWPericardialEffusion = new QCollapsableWidget("Pericardial Effusion", 120, this);
  m_Controls->PericardialEffusion = new QPericardialEffusionWidget(qp, this);
  m_Controls->CWPericardialEffusion->setVisible(true);
  m_Controls->CWPericardialEffusion->layout()->addWidget(m_Controls->PericardialEffusion);
  m_Controls->CWPericardialEffusion->setContentLayout(*m_Controls->PericardialEffusion->layout());
  m_Controls->ActionWidgets->layout()->addWidget(m_Controls->CWPericardialEffusion);
  connect(m_Controls->PericardialEffusion, SIGNAL(UpateAction(SEAction const&,SEScalarTime const&)), SIGNAL(UpateAction(SEAction const&,SEScalarTime const&)));

  m_Controls->CWPulmonaryShuntExacerbation = new QCollapsableWidget("Pulmonary Shunt Exacerbation", 120, this);
  m_Controls->PulmonaryShuntExacerbation = new QPulmonaryShuntExacerbationWidget(qp, this);
  m_Controls->CWPulmonaryShuntExacerbation->setVisible(true);
  m_Controls->CWPulmonaryShuntExacerbation->layout()->addWidget(m_Controls->PulmonaryShuntExacerbation);
  m_Controls->CWPulmonaryShuntExacerbation->setContentLayout(*m_Controls->PulmonaryShuntExacerbation->layout());
  m_Controls->ActionWidgets->layout()->addWidget(m_Controls->CWPulmonaryShuntExacerbation);
  connect(m_Controls->PulmonaryShuntExacerbation, SIGNAL(UpateAction(SEAction const&, SEScalarTime const&)), SIGNAL(UpateAction(SEAction const&, SEScalarTime const&)));

  m_Controls->CWRespiratoryFatigue = new QCollapsableWidget("Respiratory Fatigue", 120, this);
  m_Controls->RespiratoryFatigue = new QRespiratoryFatigueWidget(qp, this);
  m_Controls->CWRespiratoryFatigue->setVisible(true);
  m_Controls->CWRespiratoryFatigue->layout()->addWidget(m_Controls->RespiratoryFatigue);
  m_Controls->CWRespiratoryFatigue->setContentLayout(*m_Controls->RespiratoryFatigue->layout());
  m_Controls->ActionWidgets->layout()->addWidget(m_Controls->CWRespiratoryFatigue);
  connect(m_Controls->RespiratoryFatigue, SIGNAL(UpateAction(SEAction const&, SEScalarTime const&)), SIGNAL(UpateAction(SEAction const&, SEScalarTime const&)));

  m_Controls->CWSerializeState = new QCollapsableWidget("Serialization", 120, this);
  m_Controls->SerializeState = new QSerializeStateWidget(qp, this);
  m_Controls->CWSerializeState->setVisible(true);
  m_Controls->CWSerializeState->layout()->addWidget(m_Controls->SerializeState);
  m_Controls->CWSerializeState->setContentLayout(*m_Controls->SerializeState->layout());
  m_Controls->ActionWidgets->layout()->addWidget(m_Controls->CWSerializeState);
  connect(m_Controls->SerializeState, SIGNAL(UpateAction(SEAction const&, SEScalarTime const&)), SIGNAL(UpateAction(SEAction const&, SEScalarTime const&)));

  m_Controls->CWSubstanceBolus = new QCollapsableWidget("Substance Bolus", 120, this);
  m_Controls->SubstanceBolus = new QSubstanceBolusWidget(qp, this);
  m_Controls->CWSubstanceBolus->setVisible(true);
  m_Controls->CWSubstanceBolus->layout()->addWidget(m_Controls->SubstanceBolus);
  m_Controls->CWSubstanceBolus->setContentLayout(*m_Controls->SubstanceBolus->layout());
  m_Controls->ActionWidgets->layout()->addWidget(m_Controls->CWSubstanceBolus);
  connect(m_Controls->SubstanceBolus, SIGNAL(UpateAction(SEAction const&,SEScalarTime const&)), SIGNAL(UpateAction(SEAction const&,SEScalarTime const&)));

  m_Controls->CWSubstanceCompoundInfusion = new QCollapsableWidget("Substance Compound Infusion", 120, this);
  m_Controls->SubstanceCompoundInfusion = new QSubstanceCompoundInfusionWidget(qp, this);
  m_Controls->CWSubstanceCompoundInfusion->setVisible(true);
  m_Controls->CWSubstanceCompoundInfusion->layout()->addWidget(m_Controls->SubstanceCompoundInfusion);
  m_Controls->CWSubstanceCompoundInfusion->setContentLayout(*m_Controls->SubstanceCompoundInfusion->layout());
  m_Controls->ActionWidgets->layout()->addWidget(m_Controls->CWSubstanceCompoundInfusion);
  connect(m_Controls->SubstanceCompoundInfusion, SIGNAL(UpateAction(SEAction const&,SEScalarTime const&)), SIGNAL(UpateAction(SEAction const&,SEScalarTime const&)));

  m_Controls->CWSubstanceInfusion = new QCollapsableWidget("Substance Infusion", 120, this);
  m_Controls->SubstanceInfusion = new QSubstanceInfusionWidget(qp, this);
  m_Controls->CWSubstanceInfusion->setVisible(true);
  m_Controls->CWSubstanceInfusion->layout()->addWidget(m_Controls->SubstanceInfusion);
  m_Controls->CWSubstanceInfusion->setContentLayout(*m_Controls->SubstanceInfusion->layout());
  m_Controls->ActionWidgets->layout()->addWidget(m_Controls->CWSubstanceInfusion);
  connect(m_Controls->SubstanceInfusion, SIGNAL(UpateAction(SEAction const&,SEScalarTime const&)), SIGNAL(UpateAction(SEAction const&,SEScalarTime const&)));

  m_Controls->CWSupplementalOxygen = new QCollapsableWidget("Supplemental Oxygen", 120, this);
  m_Controls->SupplementalOxygen = new QSupplementalOxygenWidget(qp, this);
  m_Controls->CWSupplementalOxygen->setVisible(true);
  m_Controls->CWSupplementalOxygen->layout()->addWidget(m_Controls->SupplementalOxygen);
  m_Controls->CWSupplementalOxygen->setContentLayout(*m_Controls->SupplementalOxygen->layout());
  m_Controls->ActionWidgets->layout()->addWidget(m_Controls->CWSupplementalOxygen);
  connect(m_Controls->SupplementalOxygen, SIGNAL(UpateAction(SEAction const&,SEScalarTime const&)), SIGNAL(UpateAction(SEAction const&,SEScalarTime const&)));

  m_Controls->CWTensionPneumothorax = new QCollapsableWidget("Tension Pneumothorax", 120, this);
  m_Controls->TensionPneumothorax = new QTensionPneumothoraxWidget(qp, this);
  m_Controls->CWTensionPneumothorax->setVisible(true);
  m_Controls->CWTensionPneumothorax->layout()->addWidget(m_Controls->TensionPneumothorax);
  m_Controls->CWTensionPneumothorax->setContentLayout(*m_Controls->TensionPneumothorax->layout());
  m_Controls->ActionWidgets->layout()->addWidget(m_Controls->CWTensionPneumothorax);
  connect(m_Controls->TensionPneumothorax, SIGNAL(UpateAction(SEAction const&,SEScalarTime const&)), SIGNAL(UpateAction(SEAction const&,SEScalarTime const&)));

  m_Controls->CWUrinate = new QCollapsableWidget("Urinate", 120, this);
  m_Controls->Urinate = new QUrinateWidget(qp, this);
  m_Controls->CWUrinate->setVisible(true);
  m_Controls->CWUrinate->layout()->addWidget(m_Controls->Urinate);
  m_Controls->CWUrinate->setContentLayout(*m_Controls->Urinate->layout());
  m_Controls->ActionWidgets->layout()->addWidget(m_Controls->CWUrinate);
  connect(m_Controls->Urinate, SIGNAL(UpateAction(SEAction const&, SEScalarTime const&)), SIGNAL(UpateAction(SEAction const&, SEScalarTime const&)));

  QSpacerItem *spacer = new QSpacerItem(40, 1000, QSizePolicy::Expanding, QSizePolicy::Expanding);
  m_Controls->ActionWidgets->layout()->addItem(spacer);
}

QActionsEditorWidget::~QActionsEditorWidget()
{
  delete m_Controls;
}

void QActionsEditorWidget::Clear()
{
  m_Controls->AcuteRespiratoryDistressSyndromeExacerbation->Reset();
  m_Controls->AcuteStress->Reset();
  m_Controls->AirwayObstruction->Reset();
  m_Controls->AsthmaAttack->Reset();
  m_Controls->BrainInjury->Reset();
  m_Controls->Bronchoconstriction->Reset();
  m_Controls->CardiacArrest->Reset();
  m_Controls->ChestCompressionForceScale->Reset();
  m_Controls->ChestOcclusiveDressing->Reset();
  m_Controls->ChronicObstructivePulmonaryDiseaseExacerbation->Reset();
  //m_Controls->ConsciousRespiration->Reset();
  m_Controls->Dyspnea->Reset();
  m_Controls->Exercise->Reset();
  m_Controls->Hemorrhage->Reset();
  m_Controls->ImpairedAlveolarExchangeExacerbation->Reset();
  m_Controls->Intubation->Reset();
  m_Controls->LobarPneumoniaExacerbation->Reset();
  m_Controls->NeedleDecompression->Reset();
  m_Controls->PericardialEffusion->Reset();
  m_Controls->PulmonaryShuntExacerbation->Reset();
  m_Controls->RespiratoryFatigue->Reset();
  m_Controls->SerializeState->Reset();
  m_Controls->SubstanceBolus->Reset();
  m_Controls->SubstanceCompoundInfusion->Reset();
  m_Controls->SubstanceInfusion->Reset();
  m_Controls->SupplementalOxygen->Reset();
  m_Controls->TensionPneumothorax->Reset();
  m_Controls->Urinate->Reset();

  m_Controls->CWAcuteRespiratoryDistressSyndromeExacerbation->expand(false);
  m_Controls->CWAcuteStress->expand(false);
  m_Controls->CWAirwayObstruction->expand(false);
  m_Controls->CWAsthmaAttack->expand(false);
  m_Controls->CWBrainInjury->expand(false);
  m_Controls->CWBronchoconstriction->expand(false);
  m_Controls->CWCardiacArrest->expand(false);
  m_Controls->CWChestCompressionForceScale->expand(false);
  m_Controls->CWChestOcclusiveDressing->expand(false);
  m_Controls->CWChronicObstructivePulmonaryDiseaseExacerbation->expand(false);
  //m_Controls->CWConsciousRespiration->expand(false);
  m_Controls->CWDyspnea->expand(false);
  m_Controls->CWExercise->expand(false);
  m_Controls->CWHemorrhage->expand(false);
  m_Controls->CWImpairedAlveolarExchangeExacerbation->expand(false);
  m_Controls->CWIntubation->expand(false);
  m_Controls->CWLobarPneumoniaExacerbation->expand(false);
  m_Controls->CWNeedleDecompression->expand(false);
  m_Controls->CWPericardialEffusion->expand(false);
  m_Controls->CWPulmonaryShuntExacerbation->expand(false);
  m_Controls->CWRespiratoryFatigue->expand(false);
  m_Controls->CWSerializeState->expand(false);
  m_Controls->CWSubstanceBolus->expand(false);
  m_Controls->CWSubstanceCompoundInfusion->expand(false);
  m_Controls->CWSubstanceInfusion->expand(false);
  m_Controls->CWSupplementalOxygen->expand(false);
  m_Controls->CWTensionPneumothorax->expand(false);
  m_Controls->CWUrinate->expand(false);

  EnableInput(true);
  EnableEditControls(true);
}

void QActionsEditorWidget::EnableInput(bool b)
{
  m_Controls->AcuteRespiratoryDistressSyndromeExacerbation->SetEnabled(b);
  m_Controls->AcuteStress->SetEnabled(b);
  m_Controls->AirwayObstruction->SetEnabled(b);
  m_Controls->AsthmaAttack->SetEnabled(b);
  m_Controls->BrainInjury->SetEnabled(b);
  m_Controls->Bronchoconstriction->SetEnabled(b);
  m_Controls->CardiacArrest->SetEnabled(b);
  m_Controls->ChestCompressionForceScale->SetEnabled(b);
  m_Controls->ChestOcclusiveDressing->SetEnabled(b);
  m_Controls->ChronicObstructivePulmonaryDiseaseExacerbation->SetEnabled(b);
  //m_Controls->ConsciousRespiration->SetEnabled(b);
  m_Controls->Dyspnea->SetEnabled(b);
  m_Controls->Exercise->SetEnabled(b);
  m_Controls->Hemorrhage->SetEnabled(b);
  m_Controls->ImpairedAlveolarExchangeExacerbation->SetEnabled(b);
  m_Controls->Intubation->SetEnabled(b);
  m_Controls->LobarPneumoniaExacerbation->SetEnabled(b);
  m_Controls->NeedleDecompression->SetEnabled(b);
  m_Controls->PericardialEffusion->SetEnabled(b);
  m_Controls->PulmonaryShuntExacerbation->SetEnabled(b);
  m_Controls->RespiratoryFatigue->SetEnabled(b);
  m_Controls->SerializeState->SetEnabled(b);
  m_Controls->SubstanceBolus->SetEnabled(b);
  m_Controls->SubstanceCompoundInfusion->SetEnabled(b);
  m_Controls->SubstanceInfusion->SetEnabled(b);
  m_Controls->SupplementalOxygen->SetEnabled(b);
  m_Controls->TensionPneumothorax->SetEnabled(b);
  m_Controls->Urinate->SetEnabled(b);
}

void QActionsEditorWidget::EnableEditControls(bool b)
{
  m_Controls->AcuteRespiratoryDistressSyndromeExacerbation->ShowProcessTimeCtrl(b);
  m_Controls->AcuteStress->ShowProcessTimeCtrl(b);
  m_Controls->AirwayObstruction->ShowProcessTimeCtrl(b);
  m_Controls->AsthmaAttack->ShowProcessTimeCtrl(b);
  m_Controls->BrainInjury->ShowProcessTimeCtrl(b);
  m_Controls->Bronchoconstriction->ShowProcessTimeCtrl(b);
  m_Controls->CardiacArrest->ShowProcessTimeCtrl(b);
  m_Controls->ChestCompressionForceScale->ShowProcessTimeCtrl(b);
  m_Controls->ChestOcclusiveDressing->ShowProcessTimeCtrl(b);
  m_Controls->ChronicObstructivePulmonaryDiseaseExacerbation->ShowProcessTimeCtrl(b);
  //m_Controls->ConsciousRespiration->ShowProcessTimeCtrl(b);
  m_Controls->Dyspnea->ShowProcessTimeCtrl(b);
  m_Controls->Exercise->ShowProcessTimeCtrl(b);
  m_Controls->Hemorrhage->ShowProcessTimeCtrl(b);
  m_Controls->ImpairedAlveolarExchangeExacerbation->ShowProcessTimeCtrl(b);
  m_Controls->Intubation->ShowProcessTimeCtrl(b);
  m_Controls->LobarPneumoniaExacerbation->ShowProcessTimeCtrl(b);
  m_Controls->NeedleDecompression->ShowProcessTimeCtrl(b);
  m_Controls->PericardialEffusion->ShowProcessTimeCtrl(b);
  m_Controls->PulmonaryShuntExacerbation->ShowProcessTimeCtrl(b);
  m_Controls->RespiratoryFatigue->ShowProcessTimeCtrl(b);
  m_Controls->SerializeState->ShowProcessTimeCtrl(b);
  m_Controls->SubstanceBolus->ShowProcessTimeCtrl(b);
  m_Controls->SubstanceCompoundInfusion->ShowProcessTimeCtrl(b);
  m_Controls->SubstanceInfusion->ShowProcessTimeCtrl(b);
  m_Controls->SupplementalOxygen->ShowProcessTimeCtrl(b);
  m_Controls->TensionPneumothorax->ShowProcessTimeCtrl(b);
  m_Controls->Urinate->ShowProcessTimeCtrl(b);
}

void QActionsEditorWidget::OpenAction(SEAction const& action, SEScalarTime const& pTime)
{
  Clear();
  const SEAcuteRespiratoryDistressSyndromeExacerbation* ardsAction = dynamic_cast<const SEAcuteRespiratoryDistressSyndromeExacerbation*>(&action);
  if (ardsAction != nullptr)
  {
    m_Controls->AcuteRespiratoryDistressSyndromeExacerbation->SetEnabled(true);
    m_Controls->AcuteRespiratoryDistressSyndromeExacerbation->ActionToControls(*ardsAction);
    m_Controls->AcuteRespiratoryDistressSyndromeExacerbation->SetProcessTime(pTime);
    m_Controls->CWAcuteRespiratoryDistressSyndromeExacerbation->expand(true);
    return;
  }
  const SEAcuteStress* acuteStressAction = dynamic_cast<const SEAcuteStress*>(&action);
  if (acuteStressAction != nullptr)
  {
    m_Controls->AcuteStress->SetEnabled(true);
    m_Controls->AcuteStress->ActionToControls(*acuteStressAction);
    m_Controls->AcuteStress->SetProcessTime(pTime);
    m_Controls->CWAcuteStress->expand(true);
    return;
  }
  const SEAirwayObstruction* airwayObstructionAction = dynamic_cast<const SEAirwayObstruction*>(&action);
  if (airwayObstructionAction != nullptr)
  {
    m_Controls->AirwayObstruction->SetEnabled(true);
    m_Controls->AirwayObstruction->ActionToControls(*airwayObstructionAction);
    m_Controls->AirwayObstruction->SetProcessTime(pTime);
    m_Controls->CWAirwayObstruction->expand(true);
    return;
  }
  const SEAsthmaAttack* asthmaAttackAction = dynamic_cast<const SEAsthmaAttack*>(&action);
  if (asthmaAttackAction != nullptr)
  {
    m_Controls->AsthmaAttack->SetEnabled(true);
    m_Controls->AsthmaAttack->ActionToControls(*asthmaAttackAction);
    m_Controls->AsthmaAttack->SetProcessTime(pTime);
    m_Controls->CWAsthmaAttack->expand(true);
    return;
  }
  const SEBrainInjury* brainInjuryAction = dynamic_cast<const SEBrainInjury*>(&action);
  if (brainInjuryAction != nullptr)
  {
    m_Controls->BrainInjury->SetEnabled(true);
    m_Controls->BrainInjury->ActionToControls(*brainInjuryAction);
    m_Controls->BrainInjury->SetProcessTime(pTime);
    m_Controls->CWBrainInjury->expand(true);
    return;
  }
  const SEBronchoconstriction* bronchoconstrictionAction = dynamic_cast<const SEBronchoconstriction*>(&action);
  if (bronchoconstrictionAction != nullptr)
  {
    m_Controls->Bronchoconstriction->SetEnabled(true);
    m_Controls->Bronchoconstriction->ActionToControls(*bronchoconstrictionAction);
    m_Controls->Bronchoconstriction->SetProcessTime(pTime);
    m_Controls->CWBronchoconstriction->expand(true);
    return;
  }
  const SECardiacArrest* cardiacArrestAction = dynamic_cast<const SECardiacArrest*>(&action);
  if (cardiacArrestAction != nullptr)
  {
    m_Controls->CardiacArrest->SetEnabled(true);
    m_Controls->CardiacArrest->ActionToControls(*cardiacArrestAction);
    m_Controls->CardiacArrest->SetProcessTime(pTime);
    m_Controls->CWCardiacArrest->expand(true);
    return;
  }
  const SEChestCompressionForceScale* compressionForceScaleAction = dynamic_cast<const SEChestCompressionForceScale*>(&action);
  if (compressionForceScaleAction != nullptr)
  {
    m_Controls->ChestCompressionForceScale->SetEnabled(true);
    m_Controls->ChestCompressionForceScale->ActionToControls(*compressionForceScaleAction);
    m_Controls->ChestCompressionForceScale->SetProcessTime(pTime);
    m_Controls->CWChestCompressionForceScale->expand(true);
    return;
  }
  const SEChestOcclusiveDressing* chestOcclusiveAction = dynamic_cast<const SEChestOcclusiveDressing*>(&action);
  if (chestOcclusiveAction != nullptr)
  {
    m_Controls->ChestOcclusiveDressing->SetEnabled(true);
    m_Controls->ChestOcclusiveDressing->ActionToControls(*chestOcclusiveAction);
    m_Controls->ChestOcclusiveDressing->SetProcessTime(pTime);
    m_Controls->CWChestOcclusiveDressing->expand(true);
    return;
  }
  const SEChronicObstructivePulmonaryDiseaseExacerbation* COPDAction = dynamic_cast<const SEChronicObstructivePulmonaryDiseaseExacerbation*>(&action);
  if (COPDAction != nullptr)
  {
    m_Controls->ChronicObstructivePulmonaryDiseaseExacerbation->SetEnabled(true);
    m_Controls->ChronicObstructivePulmonaryDiseaseExacerbation->ActionToControls(*COPDAction);
    m_Controls->ChronicObstructivePulmonaryDiseaseExacerbation->SetProcessTime(pTime);
    m_Controls->CWChronicObstructivePulmonaryDiseaseExacerbation->expand(true);
    return;
  }
  const SEDyspnea* dyspneaAction = dynamic_cast<const SEDyspnea*>(&action);
  if (dyspneaAction != nullptr)
  {
    m_Controls->Dyspnea->SetEnabled(true);
    m_Controls->Dyspnea->ActionToControls(*dyspneaAction);
    m_Controls->Dyspnea->SetProcessTime(pTime);
    m_Controls->CWDyspnea->expand(true);
    return;
  }
  const SEExercise* exerciseAction = dynamic_cast<const SEExercise*>(&action);
  if (exerciseAction != nullptr)
  {
    m_Controls->Exercise->SetEnabled(true);
    m_Controls->Exercise->ActionToControls(*exerciseAction);
    m_Controls->Exercise->SetProcessTime(pTime);
    m_Controls->CWExercise->expand(true);
    return;
  }
  const SEHemorrhage* hemorrhageAction = dynamic_cast<const SEHemorrhage*>(&action);
  if (hemorrhageAction != nullptr)
  {
    m_Controls->Hemorrhage->SetEnabled(true);
    m_Controls->Hemorrhage->ActionToControls(*hemorrhageAction);
    m_Controls->Hemorrhage->SetProcessTime(pTime);
    m_Controls->CWHemorrhage->expand(true);
    return;
  }
  const SEImpairedAlveolarExchangeExacerbation* impairedAlveolarExchangeExacerbationAction = dynamic_cast<const SEImpairedAlveolarExchangeExacerbation*>(&action);
  if (impairedAlveolarExchangeExacerbationAction != nullptr)
  {
    m_Controls->ImpairedAlveolarExchangeExacerbation->SetEnabled(true);
    m_Controls->ImpairedAlveolarExchangeExacerbation->ActionToControls(*impairedAlveolarExchangeExacerbationAction);
    m_Controls->ImpairedAlveolarExchangeExacerbation->SetProcessTime(pTime);
    m_Controls->CWImpairedAlveolarExchangeExacerbation->expand(true);
    return;
  }
  const SEIntubation* intubationAction = dynamic_cast<const SEIntubation*>(&action);
  if (intubationAction != nullptr)
  {
    m_Controls->Intubation->SetEnabled(true);
    m_Controls->Intubation->ActionToControls(*intubationAction);
    m_Controls->Intubation->SetProcessTime(pTime);
    m_Controls->CWIntubation->expand(true);
    return;
  }
  const SELobarPneumoniaExacerbation* lobarPneumoniaExacerbationAction = dynamic_cast<const SELobarPneumoniaExacerbation*>(&action);
  if (lobarPneumoniaExacerbationAction != nullptr)
  {
    m_Controls->LobarPneumoniaExacerbation->SetEnabled(true);
    m_Controls->LobarPneumoniaExacerbation->ActionToControls(*lobarPneumoniaExacerbationAction);
    m_Controls->LobarPneumoniaExacerbation->SetProcessTime(pTime);
    m_Controls->CWLobarPneumoniaExacerbation->expand(true);
    return;
  }
  const SENeedleDecompression* needleDecompressionAction = dynamic_cast<const SENeedleDecompression*>(&action);
  if (needleDecompressionAction != nullptr)
  {
    m_Controls->NeedleDecompression->SetEnabled(true);
    m_Controls->NeedleDecompression->ActionToControls(*needleDecompressionAction);
    m_Controls->NeedleDecompression->SetProcessTime(pTime);
    m_Controls->CWNeedleDecompression->expand(true);
    return;
  }
  const SEPericardialEffusion* pericardialEffusionAction = dynamic_cast<const SEPericardialEffusion*>(&action);
  if (pericardialEffusionAction != nullptr)
  {
    m_Controls->PericardialEffusion->SetEnabled(true);
    m_Controls->PericardialEffusion->ActionToControls(*pericardialEffusionAction);
    m_Controls->PericardialEffusion->SetProcessTime(pTime);
    m_Controls->CWPericardialEffusion->expand(true);
    return;
  }
  const SEPulmonaryShuntExacerbation* pulmonaryShuntExacerbationAction = dynamic_cast<const SEPulmonaryShuntExacerbation*>(&action);
  if (pulmonaryShuntExacerbationAction != nullptr)
  {
    m_Controls->PulmonaryShuntExacerbation->SetEnabled(true);
    m_Controls->PulmonaryShuntExacerbation->ActionToControls(*pulmonaryShuntExacerbationAction);
    m_Controls->PulmonaryShuntExacerbation->SetProcessTime(pTime);
    m_Controls->CWPulmonaryShuntExacerbation->expand(true);
    return;
  }
  const SERespiratoryFatigue* RespiratoryFatigueAction = dynamic_cast<const SERespiratoryFatigue*>(&action);
  if (RespiratoryFatigueAction != nullptr)
  {
    m_Controls->RespiratoryFatigue->SetEnabled(true);
    m_Controls->RespiratoryFatigue->ActionToControls(*RespiratoryFatigueAction);
    m_Controls->RespiratoryFatigue->SetProcessTime(pTime);
    m_Controls->CWRespiratoryFatigue->expand(true);
    return;
  }
  const SESerializeState* SerializeStateAction = dynamic_cast<const SESerializeState*>(&action);
  if (SerializeStateAction != nullptr)
  {
    m_Controls->SerializeState->SetEnabled(true);
    m_Controls->SerializeState->ActionToControls(*SerializeStateAction);
    m_Controls->SerializeState->SetProcessTime(pTime);
    m_Controls->CWSerializeState->expand(true);
    return;
  }
  const SESubstanceBolus* substanceBolusAction = dynamic_cast<const SESubstanceBolus*>(&action);
  if (substanceBolusAction != nullptr)
  {
    m_Controls->SubstanceBolus->SetEnabled(true);
    m_Controls->SubstanceBolus->ActionToControls(*substanceBolusAction);
    m_Controls->SubstanceBolus->SetProcessTime(pTime);
    m_Controls->CWSubstanceBolus->expand(true);
    return;
  }
  const SESubstanceCompoundInfusion* substanceCompoundInfusionAction = dynamic_cast<const SESubstanceCompoundInfusion*>(&action);
  if (substanceCompoundInfusionAction != nullptr)
  {
    m_Controls->SubstanceCompoundInfusion->SetEnabled(true);
    m_Controls->SubstanceCompoundInfusion->ActionToControls(*substanceCompoundInfusionAction);
    m_Controls->SubstanceCompoundInfusion->SetProcessTime(pTime);
    m_Controls->CWSubstanceCompoundInfusion->expand(true);
    return;
  }
  const SESubstanceInfusion* substanceInfusionAction = dynamic_cast<const SESubstanceInfusion*>(&action);
  if (substanceInfusionAction != nullptr)
  {
    m_Controls->SubstanceInfusion->SetEnabled(true);
    m_Controls->SubstanceInfusion->ActionToControls(*substanceInfusionAction);
    m_Controls->SubstanceInfusion->SetProcessTime(pTime);
    m_Controls->CWSubstanceInfusion->expand(true);
    return;
  }
  const SESupplementalOxygen* supplementalOxygenAction = dynamic_cast<const SESupplementalOxygen*>(&action);
  if (supplementalOxygenAction != nullptr)
  {
    m_Controls->SupplementalOxygen->SetEnabled(true);
    m_Controls->SupplementalOxygen->ActionToControls(*supplementalOxygenAction);
    m_Controls->SupplementalOxygen->SetProcessTime(pTime);
    m_Controls->CWSupplementalOxygen->expand(true);
    return;
  }
  const SETensionPneumothorax* tensionPneumothoraxAction = dynamic_cast<const SETensionPneumothorax*>(&action);
  if (tensionPneumothoraxAction != nullptr)
  {
    m_Controls->TensionPneumothorax->SetEnabled(true);
    m_Controls->TensionPneumothorax->ActionToControls(*tensionPneumothoraxAction);
    m_Controls->TensionPneumothorax->SetProcessTime(pTime);
    m_Controls->CWTensionPneumothorax->expand(true);
    return;
  }
  const SEUrinate* urinateAction = dynamic_cast<const SEUrinate*>(&action);
  if (urinateAction != nullptr)
  {
    m_Controls->Urinate->SetEnabled(true);
    m_Controls->Urinate->ActionToControls(*urinateAction);
    m_Controls->Urinate->SetProcessTime(pTime);
    m_Controls->CWUrinate->expand(true);
    return;
  }
}

void QActionsEditorWidget::AtSteadyState(PhysiologyEngine& pulse)
{
  m_Controls->AcuteRespiratoryDistressSyndromeExacerbation->AtSteadyState(pulse);
  m_Controls->AcuteStress->AtSteadyState(pulse);
  m_Controls->AirwayObstruction->AtSteadyState(pulse);
  m_Controls->AsthmaAttack->AtSteadyState(pulse);
  m_Controls->BrainInjury->AtSteadyState(pulse);
  m_Controls->Bronchoconstriction->AtSteadyState(pulse);
  m_Controls->CardiacArrest->AtSteadyState(pulse);
  m_Controls->ChestCompressionForceScale->AtSteadyState(pulse);
  m_Controls->ChestOcclusiveDressing->AtSteadyState(pulse);
  m_Controls->ChronicObstructivePulmonaryDiseaseExacerbation->AtSteadyState(pulse);
  //m_Controls->ConsciousRespiration->AtSteadyState(pulse);
  m_Controls->Dyspnea->AtSteadyState(pulse);
  m_Controls->Exercise->AtSteadyState(pulse);
  m_Controls->Hemorrhage->AtSteadyState(pulse);
  m_Controls->ImpairedAlveolarExchangeExacerbation->AtSteadyState(pulse);
  m_Controls->Intubation->AtSteadyState(pulse);
  m_Controls->LobarPneumoniaExacerbation->AtSteadyState(pulse);
  m_Controls->NeedleDecompression->AtSteadyState(pulse);
  m_Controls->PericardialEffusion->AtSteadyState(pulse);
  m_Controls->PulmonaryShuntExacerbation->AtSteadyState(pulse);
  m_Controls->RespiratoryFatigue->AtSteadyState(pulse);
  m_Controls->SerializeState->AtSteadyState(pulse);
  m_Controls->SubstanceBolus->AtSteadyState(pulse);
  m_Controls->SubstanceCompoundInfusion->AtSteadyState(pulse);
  m_Controls->SubstanceInfusion->AtSteadyState(pulse);
  m_Controls->SupplementalOxygen->AtSteadyState(pulse);
  m_Controls->TensionPneumothorax->AtSteadyState(pulse);
  m_Controls->Urinate->AtSteadyState(pulse);
}
void QActionsEditorWidget::AtSteadyStateUpdateUI()
{
  EnableInput(m_Controls->Pulse.GetMode() == ExplorerMode::Editor);

  m_Controls->AcuteRespiratoryDistressSyndromeExacerbation->AtSteadyStateUpdateUI();
  m_Controls->AcuteStress->AtSteadyStateUpdateUI();
  m_Controls->AirwayObstruction->AtSteadyStateUpdateUI();
  m_Controls->AsthmaAttack->AtSteadyStateUpdateUI();
  m_Controls->BrainInjury->AtSteadyStateUpdateUI();
  m_Controls->Bronchoconstriction->AtSteadyStateUpdateUI();
  m_Controls->CardiacArrest->AtSteadyStateUpdateUI();
  m_Controls->ChestCompressionForceScale->AtSteadyStateUpdateUI();
  m_Controls->ChestOcclusiveDressing->AtSteadyStateUpdateUI();
  m_Controls->ChronicObstructivePulmonaryDiseaseExacerbation->AtSteadyStateUpdateUI();
  //m_Controls->ConsciousRespiration->AtSteadyStateUpdateUI();
  m_Controls->Dyspnea->AtSteadyStateUpdateUI();
  m_Controls->Exercise->AtSteadyStateUpdateUI();
  m_Controls->Hemorrhage->AtSteadyStateUpdateUI();
  m_Controls->ImpairedAlveolarExchangeExacerbation->AtSteadyStateUpdateUI();
  m_Controls->Intubation->AtSteadyStateUpdateUI();
  m_Controls->LobarPneumoniaExacerbation->AtSteadyStateUpdateUI();
  m_Controls->NeedleDecompression->AtSteadyStateUpdateUI();
  m_Controls->PericardialEffusion->AtSteadyStateUpdateUI();
  m_Controls->PulmonaryShuntExacerbation->AtSteadyStateUpdateUI();
  m_Controls->RespiratoryFatigue->AtSteadyStateUpdateUI();
  m_Controls->SerializeState->AtSteadyStateUpdateUI();
  m_Controls->SubstanceBolus->AtSteadyStateUpdateUI();
  m_Controls->SubstanceCompoundInfusion->AtSteadyStateUpdateUI();
  m_Controls->SubstanceInfusion->AtSteadyStateUpdateUI();
  m_Controls->SupplementalOxygen->AtSteadyStateUpdateUI();
  m_Controls->TensionPneumothorax->AtSteadyStateUpdateUI();
  m_Controls->Urinate->AtSteadyStateUpdateUI();
}

void QActionsEditorWidget::ProcessPhysiology(PhysiologyEngine& pulse)
{
  m_Controls->AcuteRespiratoryDistressSyndromeExacerbation->ProcessPhysiology(pulse);
  m_Controls->AcuteStress->ProcessPhysiology(pulse);
  m_Controls->AirwayObstruction->ProcessPhysiology(pulse);
  m_Controls->AsthmaAttack->ProcessPhysiology(pulse);
  m_Controls->BrainInjury->ProcessPhysiology(pulse);
  m_Controls->Bronchoconstriction->ProcessPhysiology(pulse);
  m_Controls->CardiacArrest->ProcessPhysiology(pulse);
  m_Controls->ChestCompressionForceScale->ProcessPhysiology(pulse);
  m_Controls->ChestOcclusiveDressing->ProcessPhysiology(pulse);
  m_Controls->ChronicObstructivePulmonaryDiseaseExacerbation->ProcessPhysiology(pulse);
  //m_Controls->ConsciousRespiration->ProcessPhysiology(pulse);
  m_Controls->Dyspnea->ProcessPhysiology(pulse);
  m_Controls->Exercise->ProcessPhysiology(pulse);
  m_Controls->Hemorrhage->ProcessPhysiology(pulse);
  m_Controls->ImpairedAlveolarExchangeExacerbation->ProcessPhysiology(pulse);
  m_Controls->Intubation->ProcessPhysiology(pulse);
  m_Controls->LobarPneumoniaExacerbation->ProcessPhysiology(pulse);
  m_Controls->NeedleDecompression->ProcessPhysiology(pulse);
  m_Controls->PericardialEffusion->ProcessPhysiology(pulse);
  m_Controls->PulmonaryShuntExacerbation->ProcessPhysiology(pulse);
  m_Controls->RespiratoryFatigue->ProcessPhysiology(pulse);
  m_Controls->SerializeState->ProcessPhysiology(pulse);
  m_Controls->SubstanceBolus->ProcessPhysiology(pulse);
  m_Controls->SubstanceCompoundInfusion->ProcessPhysiology(pulse);
  m_Controls->SubstanceInfusion->ProcessPhysiology(pulse);
  m_Controls->SupplementalOxygen->ProcessPhysiology(pulse);
  m_Controls->TensionPneumothorax->ProcessPhysiology(pulse);
  m_Controls->Urinate->ProcessPhysiology(pulse);
}
void QActionsEditorWidget::PhysiologyUpdateUI()
{
  m_Controls->AcuteRespiratoryDistressSyndromeExacerbation->PhysiologyUpdateUI();
  m_Controls->AcuteStress->PhysiologyUpdateUI();
  m_Controls->AirwayObstruction->PhysiologyUpdateUI();
  m_Controls->AsthmaAttack->PhysiologyUpdateUI();
  m_Controls->BrainInjury->PhysiologyUpdateUI();
  m_Controls->Bronchoconstriction->PhysiologyUpdateUI();
  m_Controls->CardiacArrest->PhysiologyUpdateUI();
  m_Controls->ChestCompressionForceScale->PhysiologyUpdateUI();
  m_Controls->ChestOcclusiveDressing->PhysiologyUpdateUI();
  m_Controls->ChronicObstructivePulmonaryDiseaseExacerbation->PhysiologyUpdateUI();
  //m_Controls->ConsciousRespiration->PhysiologyUpdateUI();
  m_Controls->Dyspnea->PhysiologyUpdateUI();
  m_Controls->Exercise->PhysiologyUpdateUI();
  m_Controls->Hemorrhage->PhysiologyUpdateUI();
  m_Controls->ImpairedAlveolarExchangeExacerbation->PhysiologyUpdateUI();
  m_Controls->Intubation->PhysiologyUpdateUI();
  m_Controls->LobarPneumoniaExacerbation->PhysiologyUpdateUI();
  m_Controls->NeedleDecompression->PhysiologyUpdateUI();
  m_Controls->PericardialEffusion->PhysiologyUpdateUI();
  m_Controls->PulmonaryShuntExacerbation->PhysiologyUpdateUI();
  m_Controls->RespiratoryFatigue->PhysiologyUpdateUI();
  m_Controls->SerializeState->PhysiologyUpdateUI();
  m_Controls->SubstanceBolus->PhysiologyUpdateUI();
  m_Controls->SubstanceCompoundInfusion->PhysiologyUpdateUI();
  m_Controls->SubstanceInfusion->PhysiologyUpdateUI();
  m_Controls->SupplementalOxygen->PhysiologyUpdateUI();
  m_Controls->TensionPneumothorax->PhysiologyUpdateUI();
  m_Controls->Urinate->PhysiologyUpdateUI();
}
