#-----------------------------------------------------------------------------
# Add External Project
#-----------------------------------------------------------------------------
include(${CMAKE_CURRENT_SOURCE_DIR}/AddExternalProject.cmake)
define_external_dirs_ex(qtExtensions)

# We don't want to install this to our packaged directory
# if we are are not creating any exports
if( ${${PROJECT_NAME}_LIBRARY_ONLY} OR ${${PROJECT_NAME}_CREATE_EXPORT})
  set(qtExtensions_ROOT_DIR ${CMAKE_INSTALL_PREFIX})
else()
  set(qtExtensions_ROOT_DIR ${qtExtensions_PREFIX}/install)
endif()

add_external_project_ex(qtExtensions
  GIT_REPOSITORY https://github.com/Kitware/qtextensions.git
  GIT_TAG master
  CMAKE_CACHE_ARGS 
    -DQt5_DIR:PATH=${Qt5_DIR}
    -DCMAKE_INSTALL_PREFIX:PATH=${qtExtensions_ROOT_DIR}
  RELATIVE_INCLUDE_PATH ""
  DEPENDENCIES ""
  #VERBOSE
  )
if (NOT USE_SYSTEM_qtExtensions)
  set(qtExtensions_DIR ${qtExtensions_ROOT_DIR}/lib/cmake/qtExtensions)
  message(STATUS "qtExtensions_DIR : ${qtExtensions_DIR}")
endif()
