/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#include "ExplorerIntroWidget.h"
#include "ui_ExplorerIntro.h"

#include "CommonDataModel.h"
#include "utils/FileUtils.h"

class QExplorerIntroWidget::Controls : public Ui::ExplorerIntroWidget
{
public:
};

QExplorerIntroWidget::QExplorerIntroWidget(QWidget *parent, Qt::WindowFlags flags) : QDockWidget(parent,flags)
{
  m_Controls = new Controls();
  m_Controls->setupUi(this);

  m_Controls->LoadShowcase->setEnabled(true);
  m_Controls->ShowcaseComboBox->setEnabled(true);
  m_Controls->LoadPulseEditor->setEnabled(true);
  QPixmap pic("resource/pulse_logo.png");
  m_Controls->Icon->setPixmap(pic);

  connect(m_Controls->LoadShowcase, SIGNAL(clicked()), parentWidget(), SLOT(StartShowcase()));
  connect(m_Controls->LoadPulseEditor, SIGNAL(clicked()), parentWidget(), SLOT(StartPulseEditor()));
}

QExplorerIntroWidget::~QExplorerIntroWidget()
{
  delete m_Controls;
}

QString QExplorerIntroWidget::GetSelectedShowcase()
{
  return m_Controls->ShowcaseComboBox->currentText();
}
