/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#include "LobarPneumoniaWidget.h"
#include "controls/ScalarWidget.h"

#include "CommonDataModel.h"
#include "patient/conditions/SELobarPneumonia.h"
#include "properties/SEScalar0To1.h"

class QLobarPneumoniaWidget::Controls
{
public:
  Controls() {}
  QScalarWidget* Severity;
  QScalarWidget* LeftLungAffected;
  QScalarWidget* RightLungAffected;
  SELobarPneumonia Condition;
};

QLobarPneumoniaWidget::QLobarPneumoniaWidget(QWidget *parent, Qt::WindowFlags flags) : QConditionWidget(parent,flags)
{
  m_Controls = new Controls();
  m_Controls->Severity = new QScalarWidget("Severity", 0, 1, 0.1, ScalarOptionWidget::None, this);
  m_Controls->LeftLungAffected = new QScalarWidget("Left Lung Affected", 0, 1, 0.1, ScalarOptionWidget::None, this);
  m_Controls->RightLungAffected = new QScalarWidget("Right Lung Affected", 0, 1, 0.1, ScalarOptionWidget::None, this);
  layout()->addWidget(m_Controls->Severity);
  layout()->addWidget(m_Controls->LeftLungAffected);
  layout()->addWidget(m_Controls->RightLungAffected);
  Reset();
}

QLobarPneumoniaWidget::~QLobarPneumoniaWidget()
{
  delete m_Controls;
}

void QLobarPneumoniaWidget::Reset()
{
  QConditionWidget::Reset();
  m_Controls->Condition.Clear();
  m_Controls->Severity->Reset();
  m_Controls->LeftLungAffected->Reset();
  m_Controls->RightLungAffected->Reset();
  EnableProperties(false);
}

void QLobarPneumoniaWidget::EnableProperties(bool b)
{
  m_Controls->Severity->EnableInput(b);
  m_Controls->LeftLungAffected->EnableInput(b);
  m_Controls->RightLungAffected->EnableInput(b);
}
void QLobarPneumoniaWidget::EnableConverter(bool b)
{
}

const SECondition& QLobarPneumoniaWidget::GetCondition()
{
  m_Controls->Condition.Clear();
  m_Controls->Severity->GetValue(m_Controls->Condition.GetSeverity());
  m_Controls->LeftLungAffected->GetValue(m_Controls->Condition.GetLeftLungAffected());
  m_Controls->RightLungAffected->GetValue(m_Controls->Condition.GetRightLungAffected());
  return m_Controls->Condition;
}

void QLobarPneumoniaWidget::SetCondition(const SECondition& c)
{
  m_Controls->Condition.Copy(static_cast<const SELobarPneumonia&>(c));
  m_Controls->Severity->SetValue(m_Controls->Condition.GetSeverity());
  m_Controls->LeftLungAffected->SetValue(m_Controls->Condition.GetLeftLungAffected());
  m_Controls->RightLungAffected->SetValue(m_Controls->Condition.GetRightLungAffected());
  QConditionWidget::EnableCondition(c.IsActive());
}

