/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#include "ChronicObstructivePulmonaryDiseaseWidget.h"
#include "controls/ScalarWidget.h"

#include "CommonDataModel.h"
#include "patient/conditions/SEChronicObstructivePulmonaryDisease.h"
#include "properties/SEScalar0To1.h"

class QChronicObstructivePulmonaryDiseaseWidget::Controls
{
public:
  Controls() {}
  SEChronicObstructivePulmonaryDisease Condition;
  QScalarWidget* BronchitisSeverity;
  QScalarWidget* EmphysemaSeverity;
};

QChronicObstructivePulmonaryDiseaseWidget::QChronicObstructivePulmonaryDiseaseWidget(QWidget *parent, Qt::WindowFlags flags) : QConditionWidget(parent,flags)
{
  m_Controls = new Controls();
  m_Controls->BronchitisSeverity = new QScalarWidget("Bronchitis Severity", 0, 1, 0.1, ScalarOptionWidget::None, this);
  m_Controls->EmphysemaSeverity = new QScalarWidget("Emphysema Severity", 0, 1, 0.1, ScalarOptionWidget::None, this);
  layout()->addWidget(m_Controls->BronchitisSeverity);
  layout()->addWidget(m_Controls->EmphysemaSeverity);
  Reset();
}

QChronicObstructivePulmonaryDiseaseWidget::~QChronicObstructivePulmonaryDiseaseWidget()
{
  delete m_Controls;
}

void QChronicObstructivePulmonaryDiseaseWidget::Reset()
{
  QConditionWidget::Reset();
  m_Controls->Condition.Clear();
  m_Controls->BronchitisSeverity->Reset();
  m_Controls->EmphysemaSeverity->Reset();
  EnableProperties(false);
}

void QChronicObstructivePulmonaryDiseaseWidget::EnableProperties(bool b)
{
  m_Controls->BronchitisSeverity->EnableInput(b);
  m_Controls->EmphysemaSeverity->EnableInput(b);
}
void QChronicObstructivePulmonaryDiseaseWidget::EnableConverter(bool b)
{
}

const SECondition& QChronicObstructivePulmonaryDiseaseWidget::GetCondition()
{
  m_Controls->Condition.Clear();
  m_Controls->BronchitisSeverity->GetValue(m_Controls->Condition.GetBronchitisSeverity());
  m_Controls->EmphysemaSeverity->GetValue(m_Controls->Condition.GetEmphysemaSeverity());
  return m_Controls->Condition;
}

void QChronicObstructivePulmonaryDiseaseWidget::SetCondition(const SECondition& c)
{
  m_Controls->Condition.Copy(static_cast<const SEChronicObstructivePulmonaryDisease&>(c));
  m_Controls->BronchitisSeverity->SetValue(m_Controls->Condition.GetBronchitisSeverity());
  m_Controls->EmphysemaSeverity->SetValue(m_Controls->Condition.GetEmphysemaSeverity());
  QConditionWidget::EnableCondition(c.IsActive());
}

