/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#include "actions/UrinateWidget.h"
#include "controls/ScalarWidget.h"

#include "CommonDataModel.h"
#include "PhysiologyEngine.h"
#include "properties/SEScalar0To1.h"
#include <QString>
#include <vector>
#include "controls/LabeledComboBox.h"

class QUrinateWidget::Controls
{
public:
  Controls(QPulse& qp) : Pulse(qp) {}
  QPulse&               Pulse;
  SEUrinate             Action;
};

QUrinateWidget::QUrinateWidget(QPulse& qp, QWidget *parent, Qt::WindowFlags flags) : QActionWidget(qp, parent, flags)
{
  m_Controls = new Controls(qp);
  Properties()->layout()->addWidget(GetProcessTimeCtrl());
  Reset();
}

QUrinateWidget::~QUrinateWidget()
{
  delete m_Controls;
}

void QUrinateWidget::Reset()
{
  QActionWidget::Reset();
  m_Controls->Action.Clear();
}

SEAction& QUrinateWidget::GetAction()
{
  return m_Controls->Action;
}
const SEAction& QUrinateWidget::GetAction() const
{
  return m_Controls->Action;
}

void QUrinateWidget::SetEnabled(bool b)
{
  QActionWidget::SetEnabled(b);
}

void QUrinateWidget::ControlsToAction()
{
  QActionWidget::ControlsToAction();
  emit UpateAction(m_Controls->Action, GetProcessTime());
}

void QUrinateWidget::ActionToControls(const SEUrinate& action)
{

}
