/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#include "actions/ChestCompressionForceScaleWidget.h"
#include "controls/ScalarWidget.h"
#include "controls/ScalarQuantityWidget.h"

#include "CommonDataModel.h"
#include "PhysiologyEngine.h"
#include "properties/SEScalar0To1.h"
#include "properties/SEScalarTime.h"

class QChestCompressionForceScaleWidget::Controls
{
public:
  Controls(QPulse& qp) : Pulse(qp) {}
  QPulse&                          Pulse;
  SEChestCompressionForceScale     Action;
  QScalarWidget*                   ForceScale;
  QScalarQuantityWidget<TimeUnit>* ForcePeriod;
};

QChestCompressionForceScaleWidget::QChestCompressionForceScaleWidget(QPulse& qp, QWidget *parent, Qt::WindowFlags flags) : QActionWidget(qp, parent, flags)
{
  m_Controls = new Controls(qp);
  m_Controls->ForceScale = new QScalarWidget("ForceScale", 0, 1, 0.1, ScalarOptionWidget::None, this);
  m_Controls->ForcePeriod = new QScalarQuantityWidget<TimeUnit>("ForcePeriod", 0, 10, .25, TimeUnit::s, ScalarOptionWidget::None, this);
  Properties()->layout()->addWidget(m_Controls->ForceScale);
  Properties()->layout()->addWidget(m_Controls->ForcePeriod);
  Properties()->layout()->addWidget(GetProcessTimeCtrl());
  
  Reset();
}

QChestCompressionForceScaleWidget::~QChestCompressionForceScaleWidget()
{
  delete m_Controls;
}

void QChestCompressionForceScaleWidget::Reset()
{
  QActionWidget::Reset();
  m_Controls->Action.Clear();
  m_Controls->ForceScale->Reset();
  m_Controls->ForcePeriod->Reset();
}

SEAction& QChestCompressionForceScaleWidget::GetAction()
{
  return m_Controls->Action;
}
const SEAction& QChestCompressionForceScaleWidget::GetAction() const
{
  return m_Controls->Action;
}

void QChestCompressionForceScaleWidget::SetEnabled(bool b)
{
  QActionWidget::SetEnabled(b);
  m_Controls->ForceScale->EnableInput(b);
  m_Controls->ForcePeriod->EnableInput(b);
  m_Controls->ForcePeriod->setEnabled(b);
}

void QChestCompressionForceScaleWidget::ControlsToAction()
{
  QActionWidget::ControlsToAction();
  m_Controls->ForceScale->GetValue(m_Controls->Action.GetForceScale());
  m_Controls->ForcePeriod->GetValue(m_Controls->Action.GetForcePeriod());
  emit UpateAction(m_Controls->Action, GetProcessTime());
}

void QChestCompressionForceScaleWidget::ActionToControls(const SEChestCompressionForceScale& action)
{
  SEScalar data;
  SEScalarQuantity<TimeUnit> timeData;
  data.SetValue(action.GetForceScale());
  m_Controls->ForceScale->SetValue(data);
  timeData.SetValue(action.GetForcePeriod(TimeUnit::s), TimeUnit::s);
  m_Controls->ForcePeriod->SetValue(timeData);
}
