/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#include "actions/CardiacArrestWidget.h"
#include "controls/ScalarWidget.h"
#include "controls/ScalarQuantityWidget.h"

#include "CommonDataModel.h"
#include "PhysiologyEngine.h"
#include "properties/SEScalar0To1.h"
#include <QString>
#include <vector>
#include "controls/LabeledComboBox.h"

class QCardiacArrestWidget::Controls
{
public:
  Controls(QPulse& qp) : Pulse(qp) {}
  QPulse&           Pulse;
  SECardiacArrest   Action;
  QLabeledComboBox* State;
};

QCardiacArrestWidget::QCardiacArrestWidget(QPulse& qp, QWidget *parent, Qt::WindowFlags flags) : QActionWidget(qp, parent, flags)
{
  m_Controls = new Controls(qp);
  std::vector<QString> stateOptions = { "On", "Off" };
  m_Controls->State = new QLabeledComboBox(this, "State", stateOptions);
  Properties()->layout()->addWidget(m_Controls->State);
  Properties()->layout()->addWidget(GetProcessTimeCtrl());
  Reset();
}

QCardiacArrestWidget::~QCardiacArrestWidget()
{
  delete m_Controls;
}

void QCardiacArrestWidget::Reset()
{
  QActionWidget::Reset();
  m_Controls->Action.Clear();
}

SEAction& QCardiacArrestWidget::GetAction()
{
  return m_Controls->Action;
}
const SEAction& QCardiacArrestWidget::GetAction() const
{
  return m_Controls->Action;
}

void QCardiacArrestWidget::SetEnabled(bool b)
{
  QActionWidget::SetEnabled(b);
  m_Controls->State->SetEnabled(b);
}

void QCardiacArrestWidget::ControlsToAction()
{
  QActionWidget::ControlsToAction();
  (m_Controls->State->GetIndex() == 0) ?
    m_Controls->Action.SetState(eSwitch::On) :
    m_Controls->Action.SetState(eSwitch::Off);
  emit UpateAction(m_Controls->Action, GetProcessTime());
}

void QCardiacArrestWidget::ActionToControls(const SECardiacArrest& action)
{
  action.GetState();
  QComboBox* stateBox = m_Controls->State->GetComboBox();
  switch (action.GetState()) {
  case eSwitch::On:
    stateBox->setCurrentIndex(stateBox->findText("On"));
    break;
  case eSwitch::Off:
    stateBox->setCurrentIndex(stateBox->findText("Off"));
    break;
  default:
    stateBox->setCurrentIndex(stateBox->findText("Off"));
    break;
  }
}
