/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#ifndef PhysiologyExplorerMainWindow_H
#define PhysiologyExplorerMainWindow_H

#include <QMainWindow>
#include <QObject>
#include "QPulse.h"


namespace Ui {
  class MainExplorerWindow;
}

class MainExplorerWindow : public QMainWindow, public PulseListener
{
  Q_OBJECT

public:
  MainExplorerWindow();
  ~MainExplorerWindow();
  void closeEvent(QCloseEvent *event);

  void AtSteadyState(PhysiologyEngine& pulse);
  void AtSteadyStateUpdateUI(); // Main Window will call this to update UI Components
  void ProcessPhysiology(PhysiologyEngine& pulse);
  void PhysiologyUpdateUI();// Main Window will call this to update UI Components

protected:

protected slots:
  void PlayPause();
  void RunInRealtime();
  void ResetExplorer();
  void ResetEngine();
  void Save();

  void StartShowcase();
  void SetupScenarioEditor();
  void SetupEngineState();
  void SetupPatientEditor();
  /**/void StartEngine();

private:
  class Controls;
  Controls* m_Controls;
};

#endif // MainExplorerWindow_H
