/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#include "PulmonaryFibrosisWidget.h"
#include "controls/ScalarWidget.h"

#include "cdm/CommonDataModel.h"
#include "cdm/patient/conditions/SEPulmonaryFibrosis.h"
#include "cdm/properties/SEScalar0To1.h"

class QPulmonaryFibrosisWidget::Controls
{
public:
  Controls() {}
  QScalarWidget* Severity;
  SEPulmonaryFibrosis Condition;
};

QPulmonaryFibrosisWidget::QPulmonaryFibrosisWidget(QWidget *parent, Qt::WindowFlags flags) : QConditionWidget(parent,flags)
{
  m_Controls = new Controls();
  m_Controls->Severity = new QScalarWidget("Severity", 0, 1, 0.1, ScalarOptionWidget::None, this);
  layout()->addWidget(m_Controls->Severity);
  reset();
}

QPulmonaryFibrosisWidget::~QPulmonaryFibrosisWidget()
{
  delete m_Controls;
}

void QPulmonaryFibrosisWidget::reset()
{
  QConditionWidget::reset();
  m_Controls->Condition.Clear();
  m_Controls->Severity->reset();
  enableProperties(false);
}

void QPulmonaryFibrosisWidget::enableProperties(bool b)
{
  m_Controls->Severity->enableInput(b);
}
void QPulmonaryFibrosisWidget::enableConverter(bool b)
{
}

const SECondition& QPulmonaryFibrosisWidget::getCondition()
{
  m_Controls->Condition.Clear();
  m_Controls->Severity->getValue(m_Controls->Condition.GetSeverity());
  return m_Controls->Condition;
}

void QPulmonaryFibrosisWidget::setCondition(const SECondition& c)
{
  m_Controls->Condition.Copy((SEPulmonaryFibrosis&)(c));
  m_Controls->Severity->setValue(m_Controls->Condition.GetSeverity());
  QConditionWidget::enableCondition(c.IsActive());
}

