/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#include "ImpairedAlveolarExchangeWidget.h"
#include "controls/ScalarWidget.h"
#include "controls/ScalarQuantityWidget.h"

#include "cdm/CommonDataModel.h"
#include "cdm/patient/conditions/SEImpairedAlveolarExchange.h"
#include "cdm/properties/SEScalar0To1.h"
#include "cdm/properties/SEScalarArea.h"

class QImpairedAlveolarExchangeWidget::Controls
{
public:
  Controls() {}
  SEImpairedAlveolarExchange Condition;
  QScalarWidget* ImpairedFraction;
  QScalarQuantityWidget<AreaUnit>* ImpairedSurfaceArea;
};

QImpairedAlveolarExchangeWidget::QImpairedAlveolarExchangeWidget(QWidget *parent, Qt::WindowFlags flags) : QConditionWidget(parent,flags)
{
  m_Controls = new Controls();
  m_Controls->ImpairedFraction = new QScalarWidget("Impaired Fraction", 0, 1, 0.1, ScalarOptionWidget::None, this);
  layout()->addWidget(m_Controls->ImpairedFraction);
  m_Controls->ImpairedSurfaceArea = new QScalarQuantityWidget<AreaUnit>("Impaired Surface Area", 0, 100, 1, AreaUnit::m2, ScalarOptionWidget::None, this);
  m_Controls->ImpairedSurfaceArea->addUnit(AreaUnit::cm2);
  layout()->addWidget(m_Controls->ImpairedSurfaceArea);
  reset();
}

QImpairedAlveolarExchangeWidget::~QImpairedAlveolarExchangeWidget()
{
  delete m_Controls;
}

void QImpairedAlveolarExchangeWidget::reset()
{
  QConditionWidget::reset();
  m_Controls->Condition.Clear();
  m_Controls->ImpairedFraction->reset();
  m_Controls->ImpairedSurfaceArea->reset();
  enableProperties(false);
}

void QImpairedAlveolarExchangeWidget::enableProperties(bool b)
{
  m_Controls->ImpairedFraction->enableInput(b);
  m_Controls->ImpairedSurfaceArea->enableInput(b);
  m_Controls->ImpairedSurfaceArea->enableConverter(!b);
}
void QImpairedAlveolarExchangeWidget::enableConverter(bool b)
{
}

const SECondition& QImpairedAlveolarExchangeWidget::getCondition()
{
  m_Controls->Condition.Clear();
  m_Controls->ImpairedFraction->getValue(m_Controls->Condition.GetImpairedFraction());
  m_Controls->ImpairedSurfaceArea->getValue(m_Controls->Condition.GetImpairedSurfaceArea());
  return m_Controls->Condition;
}

void QImpairedAlveolarExchangeWidget::setCondition(const SECondition& c)
{
  m_Controls->Condition.Copy((SEImpairedAlveolarExchange&)(c));
  m_Controls->ImpairedFraction->setValue(m_Controls->Condition.GetImpairedFraction());
  m_Controls->ImpairedSurfaceArea->setValue(m_Controls->Condition.GetImpairedSurfaceArea());
  QConditionWidget::enableCondition(c.IsActive());
}
