/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#include "ChronicAnemiaWidget.h"
#include "controls/ScalarWidget.h"

#include "cdm/CommonDataModel.h"
#include "cdm/patient/conditions/SEChronicAnemia.h"
#include "cdm/properties/SEScalar0To1.h"

class QChronicAnemiaWidget::Controls
{
public:
  Controls() {}
  SEChronicAnemia Condition;
  QScalarWidget* ReductionFactor;
};

QChronicAnemiaWidget::QChronicAnemiaWidget(QWidget *parent, Qt::WindowFlags flags) : QConditionWidget(parent, flags)
{
  m_Controls = new Controls();
  m_Controls->ReductionFactor = new QScalarWidget("Reduction Factor", 0, 1, 0.1, ScalarOptionWidget::None, this);
  layout()->addWidget(m_Controls->ReductionFactor);
  reset();
}

QChronicAnemiaWidget::~QChronicAnemiaWidget()
{
  delete m_Controls;
}

void QChronicAnemiaWidget::reset()
{
  QConditionWidget::reset();
  m_Controls->Condition.Clear();
  m_Controls->ReductionFactor->reset();
  enableProperties(false);
}

void QChronicAnemiaWidget::enableProperties(bool b)
{
  m_Controls->ReductionFactor->enableInput(b);
}
void QChronicAnemiaWidget::enableConverter(bool b)
{
}

const SECondition& QChronicAnemiaWidget::getCondition()
{
  m_Controls->Condition.Clear();
  m_Controls->ReductionFactor->getValue(m_Controls->Condition.GetReductionFactor());
  return m_Controls->Condition;
}

void QChronicAnemiaWidget::setCondition(const SECondition& c)
{
  m_Controls->Condition.Copy((SEChronicAnemia&)(c));
  m_Controls->ReductionFactor->setValue(m_Controls->Condition.GetReductionFactor());
  QConditionWidget::enableCondition(c.IsActive());
}

