/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#include "actions/TensionPneumothoraxWidget.h"
#include "controls/ScalarWidget.h"

#include "cdm/CommonDataModel.h"
#include "PhysiologyEngine.h"
#include "cdm/patient/actions/SETensionPneumothorax.h"
#include "cdm/properties/SEScalar0To1.h"
#include <QString>
#include <vector>
#include "controls/LabeledComboBox.h"

class QTensionPneumothoraxWidget::Controls
{
public:
  Controls() {}
  SETensionPneumothorax Action;
  QScalarWidget* Severity;
  QLabeledComboBox* Side;
  QLabeledComboBox* Type;

};

QTensionPneumothoraxWidget::QTensionPneumothoraxWidget(QPulse& qp, QWidget *parent, Qt::WindowFlags flags) : QActionWidget(qp, parent, flags)
{
  m_Controls = new Controls();
  m_Controls->Severity = new QScalarWidget("Severity", 0, 1, 0.1, ScalarOptionWidget::None, this); //check this

  std::vector<QString> sideOptions = {"Left", "Right"};
  std::vector<QString> typeOptions = { "Open", "Closed" };
  m_Controls->Side = new QLabeledComboBox(this, "Side", sideOptions);
  m_Controls->Type = new QLabeledComboBox(this, "Type", typeOptions);

  Properties()->layout()->addWidget(m_Controls->Severity);
  Properties()->layout()->addWidget(m_Controls->Side);
  Properties()->layout()->addWidget(m_Controls->Type);
  Reset();
}

QTensionPneumothoraxWidget::~QTensionPneumothoraxWidget()
{
  delete m_Controls;
}

void QTensionPneumothoraxWidget::Reset()
{
  QActionWidget::Reset();
  m_Controls->Action.Clear();
  m_Controls->Severity->reset();
}

void QTensionPneumothoraxWidget::SetEnabled(bool b)
{
  QActionWidget::SetEnabled(b);
  m_Controls->Severity->enableInput(b);
  m_Controls->Severity->setEnabled(b);
  m_Controls->Side->SetEnabled(b);
  m_Controls->Type->SetEnabled(b);
}

void QTensionPneumothoraxWidget::ControlsToAction()
{
  QActionWidget::ControlsToAction();
  m_Controls->Severity->getValue(m_Controls->Action.GetSeverity());
  (m_Controls->Side->GetText() == "Left") ?
    m_Controls->Action.SetSide(eSide::Left) :
    m_Controls->Action.SetSide(eSide::Right);
  (m_Controls->Type->GetText() == "Open") ?
    m_Controls->Action.SetType(eGate::Open) :
    m_Controls->Action.SetType(eGate::Closed);
}

void QTensionPneumothoraxWidget::AtSteadyState(PhysiologyEngine& pulse)
{
  // Nothing expected here
}
void QTensionPneumothoraxWidget::AtSteadyStateUpdateUI()
{
  // Nothing expected here
}

void QTensionPneumothoraxWidget::ProcessPhysiology(PhysiologyEngine& pulse)
{// This is called from a thread, you should NOT update UI here
  // This is where we pull data from pulse, and push any actions to it
  if (m_PassAction)
  {
    if (m_Controls->Action.IsValid())
      pulse.ProcessAction(m_Controls->Action);
    m_PassAction = false;
  }
}
void QTensionPneumothoraxWidget::PhysiologyUpdateUI()
{// This is called from a slot, you can update UI here

  // Nothing is expected to be in the environment
}