/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#include "actions/SupplementalOxygenWidget.h"
#include "controls/ScalarWidget.h"

#include "cdm/CommonDataModel.h"
#include "PhysiologyEngine.h"
#include "cdm/patient/actions/SESupplementalOxygen.h"
#include "cdm/properties/SEScalarVolume.h"
#include "cdm/properties/SEScalarVolumePerTime.h"
#include <QString>
#include <vector>
#include "controls/LabeledComboBox.h"
#include "controls/ScalarQuantityWidget.h"

class QSupplementalOxygenWidget::Controls
{
public:
  Controls() {}
  SESupplementalOxygen                      Action;
  QLabeledComboBox*                         Devices;
  QScalarQuantityWidget<VolumePerTimeUnit>* Flow;
  QScalarQuantityWidget<VolumeUnit>*        Volume;
};

QSupplementalOxygenWidget::QSupplementalOxygenWidget(QPulse& qp, QWidget *parent, Qt::WindowFlags flags) : QActionWidget(qp, parent, flags)
{
  m_Controls = new Controls();

  std::vector<QString> devices = {"None", "NasalCannula", "SimpleMask", "NonRebreatherMask" };
  m_Controls->Devices = new QLabeledComboBox(this, "Devices", devices, 120);
  m_Controls->Flow = new QScalarQuantityWidget<VolumePerTimeUnit>("Flow", 0, 100, 1, VolumePerTimeUnit::L_Per_min, ScalarOptionWidget::None, this);
  m_Controls->Volume = new QScalarQuantityWidget<VolumeUnit>("Volume", 0, 5000, 1, VolumeUnit::L, ScalarOptionWidget::None, this);

  Properties()->layout()->addWidget(m_Controls->Devices);
  Properties()->layout()->addWidget(m_Controls->Flow);
  Properties()->layout()->addWidget(m_Controls->Volume);
  Reset();
}

QSupplementalOxygenWidget::~QSupplementalOxygenWidget()
{
  delete m_Controls;
}

void QSupplementalOxygenWidget::Reset()
{
  QActionWidget::Reset();
  m_Controls->Action.Clear();
  m_Controls->Flow->reset();
  m_Controls->Volume->reset();
}

void QSupplementalOxygenWidget::SetEnabled(bool b)
{
  QActionWidget::SetEnabled(b);
  m_Controls->Flow->enableInput(b);
  m_Controls->Flow->setEnabled(b);
  m_Controls->Volume->enableInput(b);
  m_Controls->Volume->setEnabled(b);
  m_Controls->Devices->SetEnabled(b);
}

void QSupplementalOxygenWidget::ControlsToAction()
{
  QActionWidget::ControlsToAction();
  m_Controls->Flow->getValue(m_Controls->Action.GetFlow());
  m_Controls->Volume->getValue(m_Controls->Action.GetVolume());
  m_Controls->Action.SetDevice((eSupplementalOxygen_Device)m_Controls->Devices->GetIndex());
}

void QSupplementalOxygenWidget::AtSteadyState(PhysiologyEngine& pulse)
{
  // Nothing expected here
}
void QSupplementalOxygenWidget::AtSteadyStateUpdateUI()
{
  // Nothing expected here
}

void QSupplementalOxygenWidget::ProcessPhysiology(PhysiologyEngine& pulse)
{// This is called from a thread, you should NOT update UI here
  // This is where we pull data from pulse, and push any actions to it
  if (m_PassAction)
  {
    if (m_Controls->Action.IsValid())
      pulse.ProcessAction(m_Controls->Action);
    m_PassAction = false;
  }
}
void QSupplementalOxygenWidget::PhysiologyUpdateUI()
{// This is called from a slot, you can update UI here

  // Nothing is expected to be in the environment
}