/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#include "actions/NeedleDecompressionWidget.h"
#include "controls/ScalarWidget.h"

#include "cdm/CommonDataModel.h"
#include "PhysiologyEngine.h"
#include "cdm/patient/actions/SENeedleDecompression.h"
#include <QString>
#include <vector>
#include "controls/LabeledComboBox.h"

class QNeedleDecompressionWidget::Controls // based off of chronic anemia widget
{
public:
  Controls() {}
  SENeedleDecompression Action;
  QLabeledComboBox*     Side;
  QLabeledComboBox*     State;

};

QNeedleDecompressionWidget::QNeedleDecompressionWidget(QPulse& qp, QWidget *parent, Qt::WindowFlags flags) : QActionWidget(qp, parent, flags)
{
  m_Controls = new Controls();
  std::vector<QString> sideOptions = { "Left", "Right" };
  std::vector<QString> stateOptions = { "On", "Off" };
  m_Controls->Side = new QLabeledComboBox(this, "Side", sideOptions);
  m_Controls->State = new QLabeledComboBox(this, "State", stateOptions);
  Properties()->layout()->addWidget(m_Controls->Side);
  Properties()->layout()->addWidget(m_Controls->State);
  Reset();
}

QNeedleDecompressionWidget::~QNeedleDecompressionWidget()
{
  delete m_Controls;
}

void QNeedleDecompressionWidget::Reset()
{
  QActionWidget::Reset();
  m_Controls->Action.Clear();
}

void QNeedleDecompressionWidget::SetEnabled(bool b)
{
  QActionWidget::SetEnabled(b);
  m_Controls->Side->SetEnabled(b);
  m_Controls->State->SetEnabled(b);
}

void QNeedleDecompressionWidget::ControlsToAction()
{
  QActionWidget::ControlsToAction();
  (m_Controls->Side->GetIndex() == 0) ?
    m_Controls->Action.SetSide(eSide::Left) :
    m_Controls->Action.SetSide(eSide::Right);
  (m_Controls->State->GetIndex() == 0) ?
    m_Controls->Action.SetState(eSwitch::On) :
    m_Controls->Action.SetState(eSwitch::Off);
}

void QNeedleDecompressionWidget::AtSteadyState(PhysiologyEngine& pulse)
{
  // Nothing expected here
}
void QNeedleDecompressionWidget::AtSteadyStateUpdateUI()
{
  // Nothing expected here
}

void QNeedleDecompressionWidget::ProcessPhysiology(PhysiologyEngine& pulse)
{// This is called from a thread, you should NOT update UI here
  // This is where we pull data from pulse, and push any actions to it
  if (m_PassAction)
  {
    if (m_Controls->Action.IsValid())
      pulse.ProcessAction(m_Controls->Action);
    m_PassAction = false;
  }
}
void QNeedleDecompressionWidget::PhysiologyUpdateUI()
{// This is called from a slot, you can update UI here

  // Nothing is expected to be in the environment
}